from parallels.hosting_check.messages.utils import format_message

MESSAGES = {}

MESSAGES['web_availability_signature_found_on_target'] = format_message("""
An error message was found on the target server web page.
The web page URL: '{url}' 
The error message: '{error_message}'
""")

MESSAGES['web_availability_signature_found_in_target_log'] = format_message("""
An error message was found on the target server error log.
Error log file: '{error_log_file}' 
The error message: '{error_message}'
""")

MESSAGES['web_availability_signature_found_on_source'] = format_message("""
An error message was found on the source server web page.
The web page URL: '{url}' 
The error message: '{error_message}'
""")

MESSAGES['web_availability_webserver_returned_http_code'] = format_message("""
An HTTP status code 4xx or 5xx is returned by the web server.
The server IP: '{server_ip}'
The HTTP status code: {status_code}
The web page URL: '{url}'
""")

MESSAGES['web_availability_different_http_code'] = format_message(""" 
The HTTP status code of a web page has changed after the migration.
The status code returned by the server '{source_server_ip}': '{source_status_code}'
The status code returned by the server '{target_server_ip}': '{target_status_code}'
The web page URL: '{url}' 
""")

MESSAGES['web_availability_request_error'] = format_message("""
Web server is accessible, but the web page cannot be retrieved.
The server IP: '{server_ip}'
URL: '{url}'
The error message: {error_message}
""")

MESSAGES['web_availability_failed_to_connect'] = format_message("""
The hosting checker cannot connect to the web server.
The server IP: '{server_ip}'
URL: '{url}'
The error message: {error_message}
""")

MESSAGES['web_availability_internal_error'] = format_message("""
An internal error occurred in the hosting checker.
The error message: '{error_message}'
URL: '{url}'
The web server IP: '{server_ip}'
""")

MESSAGES['web_availability_title_missing_target'] = format_message("""
A web page returned by the target server has no HTML title.
The web page URL: '{url}'.
""")

MESSAGES['web_availability_title_missing_source'] = format_message("""
A web page returned by the source server has no HTML title.
The web page URL: '{url}'.""")

MESSAGES['web_availability_title_changed'] = format_message("""
The title of a web page has changed after the migration.
The web page URL: '{url}'
The page title on the source server: '{title_source}'
The page title on the target server: '{title_target}'
""")
MESSAGES['cannot_decode_url'] = format_message("""
Domain web page contains a link that cannot be decoded.

The URL that cannot be decoded: '{url}'
""")
