from parallels.core import checking
from parallels.core.client_subscription_converter import ClientSubscriptionConverterAdapter
from parallels.plesk.converter.converter import PleskConverter


class TargetPleskClientSubscriptionConverterAdapter(ClientSubscriptionConverterAdapter):
	def convert(self, global_context, converted_resellers, report):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		skip_ip_mapping = hasattr(global_context.options, 'skip_ip_mapping') and global_context.options.skip_ip_mapping
		converter = PleskConverter(global_context.target_existing_objects, skip_ip_mapping=skip_ip_mapping)
		converter.set_ip_mapping(global_context.ip_mapping)
		plain_report = checking.PlainReport(report, *global_context.migrator._extract_source_objects_info())
		converter.convert_dumps(
			global_context.get_sources_info(), plain_report,
			global_context.migration_list_data.subscriptions_mapping,
			global_context.migration_list_data.customers_mapping,
			converted_resellers,
			global_context.password_holder,
		)
		return converter.get_target_model()
