import ntpath

from parallels.core.connections.database_server import DatabaseServer, is_local_database_host


class PleskDatabaseTargetServer(DatabaseServer):
	def __init__(self, db_type, host, port, user, password, panel_server):
		"""
		Arguments:
		- panel_server - instance of PleskTargetServer
		"""
		self._db_type = db_type
		self._host = host
		self._port = port
		self._user = user
		self._password = password
		self._panel_server = panel_server

	def type(self):
		return self._db_type

	def host(self):
		return self._host

	def port(self):
		return self._port

	def password(self):
		return self._password

	def user(self):
		return self._user

	@property
	def panel_server(self):
		return self._panel_server

	@property
	def physical_server(self):
		if is_local_database_host(self.host(), [self._panel_server.ip()]):
			# This database is located on local panel server
			return self._panel_server
		else:
			# This database is located on external server
			# We don't have physical access to it, so return None
			return None

	@property
	def mysql_bin(self):
		if not self.is_windows():
			return 'mysql'
		else:
			return ntpath.join(
				self._panel_server.plesk_dir, "MySQL\\bin\\mysql"
			)

	@property
	def plesk_dir(self):
		return self._panel_server.plesk_dir
