import logging

from parallels.plesk.source.custom import messages
from parallels.core.actions.base.common_action import CommonAction
from parallels.plesk.source.custom.hosting_description.converter_to_dump import HostingDescriptionToPleskDumpConverter


logger = logging.getLogger(__name__)


class CreateDumpFromHostingDescription(CommonAction):
	"""Create Plesk configuration dump file (raw) out of hosting description file"""

	def get_failure_message(self, global_context):
		"""Get message for situation when action failed

		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:rtype: basestring
		"""
		return messages.ACTION_CREATE_DUMP_FAILURE

	def get_description(self):
		"""Get short description of action as string

		:rtype: basestring
		"""
		return messages.ACTION_CREATE_DUMP_DESCRIPTION

	def run(self, global_context):
		"""Run action

		:type global_context: parallels.plesk.source.custom.global_context.CustomPanelGlobalMigrationContext
		:rtype: None
		"""
		dump_creator = HostingDescriptionToPleskDumpConverter()
		conn = global_context.conn
		""":type conn: parallels.plesk.source.custom.connections.MigratorConnections"""
		for hosting_description_config in conn.iter_hosting_description_configs():
			dump_filename = (
				global_context.session_files.get_path_to_plesk_configuration_dump_created_from_hosting_description(
					hosting_description_config.source_id
				)
			)
			logger.info(messages.LOG_CREATE_DUMP, hosting_description_config.source_id)
			is_windows = global_context.conn.target.is_windows
			dump_creator.write_dump(
				hosting_description_config, dump_filename,
				database_servers=list(global_context.conn.iter_database_servers()),
				is_windows=is_windows
			)
