from parallels.core.global_context import GlobalMigrationContext
from parallels.core.global_context import SourceInfo
from parallels.core.dump import dump
from parallels.core.utils.common import cached
from parallels.plesk.source.custom.hosting_description.converter_to_dump import read_hosting_description_file
from parallels.plesk.source.custom.hosting_description.model import HostingDescriptionModel


class CustomPanelGlobalMigrationContext(GlobalMigrationContext):
	"""
	:type session_files: parallels.plesk.source.custom.session_files.CustomPanelSessionFiles
	"""
	def __init__(self):
		self.session_files = None
		super(CustomPanelGlobalMigrationContext, self).__init__()
		self.source_has_dns_forwarding = False
		self.hosting_analyzer_enabled = False
		self.post_migration_checks_enabled = False

	@cached
	def get_hosting_description(self, dump_id):
		"""
		:type dump_id: basestring
		:rtype: parallels.custom_panel_migrator.hosting_description.HostingDescriptionModel
		"""
		hosting_description_config = self.conn.get_hosting_description_config(dump_id)
		return HostingDescriptionModel(dump_id, read_hosting_description_file(hosting_description_config))

	@property
	def _sources_info(self):
		"""Information about source servers we have

		:rtype list[parallels.core.global_context.SourceInfo]
		"""
		return [
			PleskConfigurationDumpInfo(self, source_id, dump_path)
			for source_id, dump_path in self.conn.get_plesk_configuration_dump_paths().iteritems()
		]


class PleskConfigurationDumpInfo(SourceInfo):
	def __init__(self, global_context, source_id, dump_path):
		super(PleskConfigurationDumpInfo, self).__init__(source_id)
		self._global_context = global_context
		self._dump_path = dump_path

	@cached
	def load_raw_dump(self):
		return dump.load(self._dump_path, self._global_context.migration_list_data)

	@property
	def is_windows(self):
		return self.load_raw_dump().is_windows
