# Copyright 1999-2015. Parallels IP Holdings GmbH. All Rights Reserved.
package LegacyPanel::PreMigrationReport;

use strict;
use warnings;

use Sys::Hostname;

use LegacyPanel::Tree::Util;

sub makeReport($) {
  my ($messageList) = @_;

  my $report = '';
  $report .= _makeHeader();
  
  foreach my $message (@{$messageList}) {
    if (defined($message) and $message->can('toString')) {
      $report .= "\n";
      $report .= $message->toString(\&_objectToText);
    }
  }

  return $report;
}

sub _makeHeader() {
  my $hostName = hostname();
  my $date = scalar(localtime());

  return <<EOHEAD;
Pre-migration report

Server: $hostName
Date: $date
EOHEAD
}

sub _objectToText(@) {
  my ($object, $carrier) = @_;

  my $outObject = $object;
  my @path = ();

  if (defined($carrier)) {
    @path = _getTreePath($carrier);
  }
  if (!defined($outObject)) {
    $outObject = shift @path;
  }

  return ($outObject, \@path);
}

sub _getTreePath($) {
  my ($tree) = @_;

  if ($tree->isa('Tree::Simple')) {
    return map { $_->getNodeValue()->toString() } LegacyPanel::Tree::Util::getNodePath($tree);
  } else {
    return ();
  }
}

1;
