from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.source.expand.utils.backup_adapter import CentralizedMailBackup, CentralizedMailBackupRaw
from parallels.plesk.source.expand.workflow import WorkflowExtension as SourceExpandWorkflowExtension
from parallels.ppa.actions.hosting_settings.check.catch_all_redirect import CatchAllRedirect
from parallels.ppa.actions.hosting_settings.check.maillists import Maillists
from parallels.ppa.actions.hosting_settings.convert.change_catch_all_redirect import ChangeCatchAllRedirect
from parallels.ppa.actions.hosting_settings.convert.change_no_hosting_subscription_web_ips import \
	ChangeNoHostingSubscriptionWebIPsPPA
from parallels.ppa.actions.hosting_settings.convert.remove_disabled_mailsystem_without_resource import \
	RemoveDisabledMailsystemWithoutResource
from parallels.ppa.actions.hosting_settings.convert.remove_domain_keys import RemoveDomainKeys
from parallels.ppa.actions.hosting_settings.convert.remove_maillists import RemoveMaillists
from parallels.ppa.actions.hosting_settings.convert.remove_smartermail_unsupported_features import \
	RemoveSmartermailUnsupportedFeatures
from parallels.ppa.source.expand.actions.hosting_settings.convert.dns import ExpandToPPADNS


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with source-panel specific actions

		:type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
		"""
		# Base workflow is Expand to Plesk workflow
		SourceExpandWorkflowExtension().extend_workflow(workflow)

		workflow.get_path('check/check-data').insert_action(
			'check-cmail-catch-all-redirect',
			CatchAllRedirect(CentralizedMailBackupRaw())
		)
		workflow.get_path('check/check-data').insert_action(
			'check-cmail-maillists',
			Maillists(CentralizedMailBackupRaw())
		)

		workflow.get_shared_action('convert-hosting').insert_action(
			'cmail-check-catch-all-redirect',
			CatchAllRedirect(CentralizedMailBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'cmail-check-maillists',
			Maillists(CentralizedMailBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'cmail-change-catch-all-redirect',
			ChangeCatchAllRedirect(CentralizedMailBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'cmail-remove-domain-keys',
			RemoveDomainKeys(CentralizedMailBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'cmail-remove-maillists',
			RemoveMaillists(CentralizedMailBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'cmail-remove-smartermail-unsupported-features',
			RemoveSmartermailUnsupportedFeatures(CentralizedMailBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'cmail-remove-disabled-mailsystem-without-resource',
			RemoveDisabledMailsystemWithoutResource(CentralizedMailBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').replace(
			'change-no-hosting-subscription-web-ips',
			ChangeNoHostingSubscriptionWebIPsPPA(CentralizedMailBackup())
		)

		workflow.get_shared_action('convert-hosting').replace(
			'convert-dns', ExpandToPPADNS()
		)