from parallels.core.checking import PlainReport
from parallels.core.client_subscription_converter import ClientSubscriptionConverterAdapter
from parallels.ppa.source.pbas.converter import Converter


class PBASToPPAClientSubscriptionConverterAdapter(ClientSubscriptionConverterAdapter):
	def convert(self, global_context, converted_resellers, report):
		"""
		Accounts conversion for PBAS does not add new PPA customers, and does not check emails uniqueness.
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		converter = Converter(
			global_context.target_existing_objects, global_context.migrator._get_pbas_data(), global_context.options
		)
		plain_report = PlainReport(report, *global_context.migrator._extract_source_objects_info())
		converter.convert_dumps(
			global_context.get_source_servers_info(),
			plain_report, global_context.migration_list_data.subscriptions_mapping,
			global_context.password_holder
		)
		return converter.get_target_model()
