from parallels.core.utils.yaml_utils import read_yaml, write_yaml


class OldDbLimits(object):
	def __init__(self, filename):
		self.filename = filename
		self.limits = read_yaml(filename, file_may_be_absent=True, default=dict())

	def set_limits(self, subscription_name, limits):
		self.limits[subscription_name] = limits
		self._save_state()

	def get_limits(self, subscription_name):
		return self.limits.get(subscription_name)

	def _save_state(self):
		write_yaml(self.filename, self.limits)