from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.pvps import messages
from parallels.core.actions.base.compound_action import CompoundAction
from parallels.core.actions.restore.plesk.import_clients import ImportClients
from parallels.pvps.actions.check_pvps_connections import CheckPVPSConnections
from parallels.pvps.actions.convert import Convert
from parallels.pvps.actions.create_plesk_subscription import CreatePleskSubscription
from parallels.pvps.actions.create_pvps_subscription import CreatePVPSSubscription
from parallels.pvps.actions.fetch_target import FetchTarget
from parallels.plesk.actions.apache_restart_interval.restore import RestoreApacheRestartIntervalPlesk
from parallels.plesk.actions.apache_restart_interval.set import SetApacheRestartInterval
from parallels.plesk.actions.hosting_settings.restore_catch_all_smartermail_assimilate import \
	RestoreCatchAllSmartermailAssimilate
from parallels.plesk.actions.hosting_settings.reset_hosting_for_nohosting_subscription import \
	ResetHostingForSubscriptionWithoutHosting
from parallels.plesk.actions.hosting_settings.verify import VerifyHostingSettings
from parallels.plesk.actions.hosting_settings.convert.dns \
	import DNS as ActionHostingSettingsConvertDNS


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with PVPS-specific actions

		:type workflow parallels.core.workflow.base_workflow.BaseWorkflow
		:rtype None
		"""

		workflow.replace_shared_action('fetch-target', FetchTarget())

		workflow.replace_shared_action('convert', Convert())
		workflow.replace_shared_action('convert-silent', Convert())
		workflow.get_shared_action('convert-hosting').replace(
			'convert-dns', ActionHostingSettingsConvertDNS()
		)

		workflow.get_path('transfer-accounts').insert_action(
			'restore-apache-restart-interval', RestoreApacheRestartIntervalPlesk(), after='remove-imported-backups'
		)
		workflow.get_path('transfer-accounts').insert_action(
			'set-apache-restart-interval', SetApacheRestartInterval(), after='check-main-node-disk-space-requirements'
		)
		workflow.get_path('transfer-accounts').replace(
			'restore', CompoundAction(messages.CREATE_CLIENTS_AND_SUBSCRIPTIONS)
		)
		workflow.get_path('transfer-accounts/restore').insert_action(
			'import-ppa-customers', ImportClients()
		)
		workflow.get_path('transfer-accounts/restore').insert_action(
			'create-pvps-subscription', CreatePVPSSubscription()
		)
		workflow.get_path('transfer-accounts/restore-hosting').insert_action(
			'restore-catch-all-smartermail-assimilate', RestoreCatchAllSmartermailAssimilate(),
			after='restore-hosting-settings'
		)
		workflow.get_path('transfer-accounts/restore-hosting').insert_action(
			'reset-hosting-for-subscription-without-hosting',
			ResetHostingForSubscriptionWithoutHosting(), after='import-backups'
		)
		workflow.get_path('transfer-accounts').replace(
			'set-apache-restart-interval', CompoundAction()  # Apache restart interval will be set later
		)

		workflow.get_path('transfer-accounts/restore').insert_action(
			'check-pvps-connections', CheckPVPSConnections()
		)
		workflow.get_path('transfer-accounts/restore').insert_action(
			# Set Apache restart interval after create PVPS subscription.
			'set-pvps-apache-restart-interval', SetApacheRestartInterval()
		)
		workflow.get_path('transfer-accounts/restore').insert_action(
			'create-plesk-subscription', CreatePleskSubscription()
		)
		workflow.get_path('transfer-accounts').insert_action(
			'check-plesk-infrastructure', workflow.get_shared_action_pointer('check-infrastructure'),
			after='restore'
		)
		workflow.get_path('transfer-accounts').register_shutdown(
			'set-apache-restart-interval',
			'restore-apache-restart-interval'
		)

		workflow.get_shared_action('verify-hosting').insert_action(
			'verify-hosting-settings', VerifyHostingSettings()
		)

		# TODO: Implement infrastructure pre-checks for PVPS
		workflow.get_path('transfer-accounts').replace('check-connections', CompoundAction())
		workflow.get_path('transfer-accounts').replace('check-target-licenses', CompoundAction())

		# TODO: clarify if need to modify
		workflow.get_path('transfer-accounts').replace('sync-subscription-plan', CompoundAction())

		workflow.get_path('check/check-data').replace('check-conflicts', Convert())