from parallels.core.hosting_check.entity_source.service import TargetServiceInfo
from parallels.core.subscription_target_info import TargetServices, TargetServers
from parallels.core.subscription_target_info import SubscriptionServiceIPs
from parallels.plesk.client_subscription_converter import TargetPleskClientSubscriptionConverterAdapter
from parallels.plesk.import_api.import_api_unix import PleskUnixImportAPI
from parallels.plesk.import_api.import_api_windows import PleskWindowsImportAPI
from parallels.ppa.panel import Panel as PPATargetPanel
from parallels.shcm_web_sn.connections.target_connections import SHCMWebSNTargetConnections
from parallels.shcm_web_sn.connections.target_server import SHCMMoveWebspacesTargetServer
from parallels.ppa.utils import poa_utils
from parallels.core.utils.common import cached


class Panel(PPATargetPanel):
	def has_dns_forwarding(self):
		"""Whether panel should support DNS forwarding migration feature"""
		return False

	def is_write_failed_subscriptions_list(self):
		"""Whether to write failed subscriptions list file after migration

		:rtype: bool
		"""
		return False

	def get_subscription_target_services(self, global_context, subscription_name):
		"""Get location of subscriptions's hosting services on target panel

		:type global_context: parallels.shm_web_sn.source.shm_web_sn.global_context.PPAMoveWebspacesGlobalMigrationContext
		:type subscription_name: basestring
		:rtype: parallels.core.subscription_target_info.TargetServices
		"""
		return TargetServices(
			web_ips=SubscriptionServiceIPs(
				v4=global_context.webspace_ipv4,
				v6=global_context.webspace_ipv6
			),
			mail_ips=SubscriptionServiceIPs(),
			db_servers={},
			dns_ips=[]
		)

	@cached
	def get_subscription_nodes(self, global_context, subscription_name):
		conn = global_context.conn.target

		return TargetServers(
			web=self._get_target_server(conn, global_context),
			mail=None,
			database={},
			dns=[]
		)

	def get_subscription_plesk_node(self, global_context, subscription_name):
		conn = global_context.conn.target
		return SHCMMoveWebspacesTargetServer(
			conn, conn._destination_node_id, conn._destination_settings.ip,
			global_context.webspace_dst_ctx.get_partition_path()
		)

	def get_service_nodes(self, conn):
		return [
			TargetServiceInfo(
				service_type='web',
				node=self._get_target_server(conn)
			)
		]

	def get_connections(self, global_context):
		"""Get target panel connections"""
		return SHCMWebSNTargetConnections(global_context.config)

	def get_import_api(self, global_context):
		if global_context.conn.target.is_windows:
			return PleskWindowsImportAPI(global_context.conn.target)
		else:
			return PleskUnixImportAPI(global_context.conn.target)

	def get_converter_adapter(self):
		"""
		:rtype: parallels.core.client_subscription_converter.ClientSubscriptionConverterAdapter
		"""
		return TargetPleskClientSubscriptionConverterAdapter()

	def get_hosting_check_messages_panel_id(self):
		return 'plesk'

	@cached
	def _get_target_server(self, conn, global_context):
		ip = global_context.webspace_dst_ctx.get_web_sn_ip()
		host_id = poa_utils.get_host_id_by_ip(conn.poa_api(), ip)

		return SHCMMoveWebspacesTargetServer(conn, host_id, ip, global_context.webspace_dst_ctx.get_partition_path())

	def get_import_dump_additional_env_vars(self, global_context):
		env = super(Panel, self).get_import_dump_additional_env_vars(global_context)
		env.update(global_context.webspace_dst_ctx.get_as_env())

		return env

	def get_restore_hosting_additional_env_vars(self, global_context, subscription=None):
		env = super(Panel, self).get_restore_hosting_additional_env_vars(
			global_context, subscription
		)
		env.update(global_context.webspace_dst_ctx.get_as_env())
		env['SHCM_WEBSPACE_MIGRATION'] = '1'

		return env
