import logging

from parallels.plesk.source.plesk.connections import PleskMigratorConnections
from parallels.shcm_web_sn.source.shcm_web_sn.source_server import SHCMMoveWebspacesSourceServer
from parallels.shcm_web_sn.source.shcm_web_sn import SHCM_PLESK_VERSION
from parallels.ppa.connections.target_connections import PPATargetConnections
from parallels.core.utils.common import cached

logger = logging.getLogger(__name__)


class SHCMMoveWebspacesWebSnSourceConnections(PleskMigratorConnections):
	def __init__(self, global_context, target_panel, migrator_server):
		super(SHCMMoveWebspacesWebSnSourceConnections, self).__init__(global_context, target_panel, migrator_server)
		self.mn_server = PPATargetConnections(global_context.config)

	@cached
	def get_source_node(self, node_id):
		node_settings = self.get_source_plesks()[node_id]
		return SHCMMoveWebspacesSourceServer(
			node_id, node_settings, self._migrator_server, SHCM_PLESK_VERSION, self.mn_server
		)
