from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction
from parallels.core import MigrationError


class SetDNSTimingsNotSupported(CommonAction):
	def get_description(self):
		return messages.CHECK_IF_SOURCE_PANEL_SUPPORTS_SETTING

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_CHECK_IF_SOURCE_PANEL_SUPPORTS

	def run(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		raise MigrationError(messages.SETTING_LOW_DNS_TIMINGS_IS_NOT)
