from parallels.core.utils.common.logging import XmlrpcMessage
from parallels.core import messages


class LoggingTransport(object):
	def __init__(self, transport, logger):
		self.transport = transport
		self.logger = logger

	def request(self, host, handler, request_body, verbose=0):
		sane_host = self.logger.get_clean_xmlrpc_uri(host)
		self.logger.debug(messages.DEBUG_XML_RPC_REQUEST_TO, sane_host, request_body.decode('utf-8'))
		response = self.transport.request(host, handler, request_body, verbose)
		self.logger.debug(messages.DEBUG_XML_RESPONSE, XmlrpcMessage(response))
		return response

	def close(self):
		self.transport.close()
