from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import DNSForwardingIssueType

MESSAGES = {}

MESSAGES[DNSForwardingIssueType.DIFFERENT_RECORDS] = format_message("""
The source DNS server at {source_dns_server_ip} returned DNS records different from those returned by the target DNS server at {target_dns_server_ip}. {difference}
""")

MESSAGES[DNSForwardingIssueType.DNS_SERVER_TIMEOUT] = format_message("""
The DNS query to the source DNS server at {source_dns_server_ip} was timed out.
""")

MESSAGES[DNSForwardingIssueType.INTERNAL_ERROR] = format_message("""
An internal error occured: {reason}
Unable to check whether the DNS zone is resolved by the source DNS server at {source_dns_server_ip}.
""")

MESSAGES['dns_forwarding_log_checking'] = format_message("""
Checking whether DNS forwarding on the source server at {source_dns_server_ip} is working for domain {domain}
""")

MESSAGES['dns_forwarding_difference_full'] = format_message("""
Here is the difference:
{difference}
""")

MESSAGES['dns_forwarding_difference_example'] = format_message("""
Here is an example of differing records:
{difference}
All information about the differences is saved to the file {filename}
""")

MESSAGES['dns_forwarding_difference_file'] = format_message("""
The source DNS server at {source_dns_server_ip} returned DNS records different from those returned by the target DNS server at {target_dns_server_ip}:
{difference}
""")
