from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import MailAuthIssueType

MESSAGES = {}

MESSAGES[MailAuthIssueType.MAIL_IP_NOT_DEFINED] = format_message("""
The domain does not have a mail service IP address.
""")

MESSAGES[MailAuthIssueType.MAILUSER_NOT_EXIST] = format_message("""
The following mail users do not exist on target panel: {mailusers_list}.
""")

MESSAGES[MailAuthIssueType.CHECK_FAILED_IMAP] = format_message("""
Unable to log in to mailboxes over IMAP:
{mailusers_list}
""")

MESSAGES[MailAuthIssueType.INTERNAL_ERROR_IMAP] = format_message("""
Internal errors have occurred while checking if it is possible to log in to mailboxes over IMAP:
{mailusers_list}
""")

MESSAGES[MailAuthIssueType.CHECK_FAILED_SMTP] = format_message("""
Unable to log in to mailboxes over SMTP:
{mailusers_list}
""")

MESSAGES[MailAuthIssueType.INTERNAL_ERROR_SMTP] = format_message("""
Internal errors have occurred while checking if it is possible to log in to mailboxes over SMTP:
{mailusers_list}
""")

MESSAGES[MailAuthIssueType.CHECK_FAILED_POP3] = format_message("""
Unable to log in to mailboxes over POP3:
{mailusers_list}
""")

MESSAGES[MailAuthIssueType.INTERNAL_ERROR_POP3] = format_message("""
Internal errors have occurred while checking if it is possible to log in to mailboxes over POP3:
{mailusers_list}
""")

MESSAGES[MailAuthIssueType.MESSAGES_COUNT_POP3_ERROR] = format_message("""
Unable to count messages in mailboxes:
{mailusers_list}
""")

MESSAGES[MailAuthIssueType.MESSAGES_COUNT_INTERNAL_ERROR] = format_message("""
An internal error occurred while counting messages in mailboxes:
{mailusers_list}
""")

MESSAGES[MailAuthIssueType.MESSAGES_COUNT_SIGNIFICANT_DIFFERENCE] = format_message("""
There is a significant difference between the number of messages in the source and the target mailbox:
{mailusers_list}
""")

MESSAGES[MailAuthIssueType.MESSAGES_COUNT_INSIGNIFICANT_DIFFERENCE] = format_message("""
There is an insignificant difference between the number of messages in the source and the target mailbox:
{mailusers_list}
""")

MESSAGES['mail_auth_different_messages_count'] = format_message("""
on source server {source_count} mail messages, on target server {target_count} mails
""")

MESSAGES['mail_auth_cant_find_mailuser_on_source'] = format_message("""
Can't find mail user '{login}' on source server
""")

MESSAGES['failed_to_login_imap'] = format_message("""
IMAP connection to '{host}' as '{login}' failed: {reason}
""")

MESSAGES['failed_to_login_pop3'] = format_message("""
POP3 connection to '{host}' as '{login}' failed: {reason}
""")

MESSAGES['failed_to_login_smtp'] = format_message("""
SMTP connection to '{host}' as '{login}' failed: {reason}
""")