from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import DNSForwardingIssueType

MESSAGES = {}

MESSAGES[DNSForwardingIssueType.DIFFERENT_RECORDS] = format_message("""
Make sure that this domain on the source server is working in the slave DNS mode, 
with the master server set to the IP address of the corresponding PPA DNS server.
""")

MESSAGES[DNSForwardingIssueType.DNS_SERVER_TIMEOUT] = format_message("""
Make sure that:
1. The DNS server is up.
2. BIND is started on the server.
3. There are no firewall rules blocking requests to the server.
""")

MESSAGES[DNSForwardingIssueType.INTERNAL_ERROR] = format_message("""
Manually check whether this zone is resolved properly by the source DNS server.
""")
