from parallels.core.utils.message_utils import single_line_message, multi_line_message

ACTION_CONVERT_AUXILIARY_USER_ROLES_DESCRIPTION = single_line_message("""
	Convert auxiliary user roles
""")
ACTION_CONVERT_AUXILIARY_USER_ROLES_FAILURE = single_line_message("""
	Failed to convert auxiliary user roles
""")
ACTION_CONVERT_AUXILIARY_USERS = single_line_message("""
	Convert auxiliary users
""")
ACTION_CONVERT_AUXILIARY_USERS_FAILURE = single_line_message("""
	Failed to convert auxiliary users
""")
CONVERTER_UNABLE_FIND_CLIENT_WITH_LOGIN = single_line_message("""
	Unable to find a client with login "%s"
""")
ALLOWED_PLAN_PERMISSIONS = single_line_message("""
	Allowed service template permissions: %s
""")
ACTION_CREATE_HOSTING_PLANS_FAILURE = single_line_message("""
	Failed to create hosting plans
""")
CREATE_PLAN_OWNED_BY = single_line_message("""
	Create %s '%s' owned by %s
""")
ALLOWED_PLAN_HOSTING_SETTINGS = single_line_message("""
	Allowed service template hosting settings: %s
""")
FAILED_TO_CREATE_SERVICE_TEMPLATE = single_line_message("""
	Failed to create %s '%s' of %s: %s
""")
FAILED_TO_CREATE_SERVICE_TEMPLATES_ON_TARGET = multi_line_message("""
	Failed to create the following plans on target panel:
	%s
	
	Migration will be stopped. Check the log above and debug.log for more details. 
	To continue migration, create these plans manually on target panel, 
	or assign subscriptions to another plans with the help of migration list
""")
HOSTING_ADDON_PLAN = single_line_message("""
	hosting addon plan
""")
ACTION_CREATE_HOSTING_PLANS_DESCRIPTION = single_line_message("""
	Create hosting plans
""")
PLAN_ALREADY_EXISTS = single_line_message("""
	%s '%s' owned by %s already exists on the target panel, no need to create
""")
HOSTING_PLAN = single_line_message("""
	hosting plan
""")
ALLOWED_SERVICE_TEMPLATE_LIMITS = single_line_message("""
	Allowed service template limits: %s
""")
PLAN_SETTINGS = single_line_message("""
	Plan settings: %s
""")
RESELLER_TITLE = single_line_message("""
	'%s' reseller
""")
PLAN_TITLE = single_line_message("""
	%s '%s' owned by %s
""")
ACTION_CREATE_RESELLER_PLANS_DESCRIPTION = single_line_message("""
	Create admin's reseller plans
""")
ACTION_CREATE_RESELLER_PLANS_FAILURE = single_line_message("""
	Failed to create admin's reseller plans
""")
CREATE_RESELLER_PLAN_CONVERSION_ERRORS = single_line_message("""
	Unable to continue migration until there are no issues at 'error' level when creating admin's reseller plans. Please
	review the report tree above and fix the errors.
""")
FAILED_TO_CREATE_RESELLER_PLAN_SOLUTION = multi_line_message("""
	Check the log above and debug.log for more details.
	To continue migration, create the plan manually on target panel
	or assign resellers to another plan with the help of migration list.
""")
FAILED_TO_CREATE_RESELLER_PLAN_ISSUE = single_line_message("""
	Failed to create reseller plan '%s': %s
""")
RESELLER_PLANS_CONVERSION_REPORT_TITLE = single_line_message("""
	Admin's reseller plans migration status
""")
ACTION_LIVE_MIGRATION_DESCRIPTION = single_line_message("""
	Migrate Subscription's process via CRIU
""")
ACTION_LIVE_MIGRATION_FAILURE = single_line_message("""
	Failed to migrate subscription's process
""")
LIVE_MIGRATION_CHECKING_APACHE_MODULES = single_line_message("""
	Checking apache modules...
""")
LIVE_MIGRATION_CRIU_TOOLS_NOT_INSTALLED_SOLUTION = single_line_message("""
	More information about CRIU described at http://criu.org
""")
LIVE_MIGRATION_CHECKING_SELINUX = single_line_message("""
	Checking SElinux...
""")
LIVE_MIGRATION_APACHE_STARTED_ISSUE = single_line_message("""
	The apache service is started. You must stop it to continue migration
""")
LIVE_MIGRATION_NOT_EQUAL_SYSUSER_ID_ISSUE = single_line_message("""
	The identifications of sysuser on source node and on the target node are unequal.
""")
LIVE_MIGRATION_NOT_EQUAL_IPS_ISSUE = single_line_message("""
	The IP addresses of source subscription and of target subscription are unequal.
""")
LIVE_MIGRATION_KERNEL_DOES_NOT_SUPPORT_CRIU_ISSUE = multi_line_message("""
	The kernel does not support CRIU:
	%s
""")
LIVE_MIGRATION_APACHE_STARTED_SOLUTION = single_line_message("""
	To stop 'httpd' service: connect to target server using SSH and run 'apachectl stop'.
""")
LIVE_MIGRATION_SELINUX_ENABLED_ISSUE = single_line_message("""
	SELinux status is Enforcing. You must switch off SELinux.
""")
LIVE_MIGRATION_SELINUX_ENABLED_SOLUTION = single_line_message("""
	The solution is described at http://kb.parallels.com/en/115626
""")
LIVE_MIGRATION_MODULES_NOT_INSTALLED_ISSUE = single_line_message("""
	Some modules (%s) have not been installed. You must install them to continue migration.
""")
LIVE_MIGRATION_IP_ADDRESS_NOT_EXCLUSIVE_SOLUTION = single_line_message("""
	Switch IP address of subscription to exclusive.
""")
LIVE_MIGRATION_UNSUPPORTED_APACHE_MODULES_ENABLED_ISSUE = single_line_message("""
	Some modules (%s) are enabled. You must disable them to continue migration.
""")
LIVE_MIGRATION_CRITICAL_ERRORS = single_line_message("""
	Unable to continue migration via CRIU until there are issues at the 'error' level in pre-migration checks. Please
	review issues tree above and fix the errors.
""")
LIVE_MIGRATION_UNSUPPORTED_PHP_HANDLER_TYPE_ISSUE = single_line_message("""
	Unable to apply live migration for domain '%s': wrong PHP handler type.
""")
LIVE_MIGRATION_NO_SUITABLE_DOMAIN_ISSUE = single_line_message("""
	There is no suitable domain for live migration.
""")
LIVE_MIGRATION_PRE_CHECK_SOURCE_SERVER_REPORT_TITLE = single_line_message("""
	Source server
""")
LIVE_MIGRATION_IP_ADDRESS_NOT_EXCLUSIVE_ISSUE = single_line_message("""
	The IP address of subscription is not exclusive.
""")
LIVE_MIGRATION_CHECKING_PHAUL = single_line_message("""
	Checking p.haul...
""")
LIVE_MIGRATION_NOT_EQUAL_IPS_SOLUTION = single_line_message("""
	Please use IP mapping to migrate a subscription to the expected IP address.
""")
LIVE_MIGRATION_PRE_CHECK_REPORT_TITLE = single_line_message("""
	Live migrations status
""")
LIVE_MIGRATION_KERNEL_DOES_NOT_SUPPORT_CRIU_SOLUTION = single_line_message("""
	More information about CRIU described at http://criu.org
""")
LIVE_MIGRATION_NOT_EQUAL_SYSUSER_ID_SOLUTION = single_line_message("""
	You can change sysuser id manually.
""")
LIVE_MIGRATION_TOOL_NOT_INSTALLED_ISSUE = single_line_message("""
	The tool '%s' is not installed or not specified in the system PATH.
""")
LIVE_MIGRATION_UNSUPPORTED_PHP_HANDLER_TYPE_SOLUTION = single_line_message("""
	You must switch PHP handler to "Apache mode".
""")
LIVE_MIGRATION_CHECKING_CRIU = single_line_message("""
	Checking criu...
""")
LIVE_MIGRATION_TOOL_NOT_CONFIGURED_ISSUE = single_line_message("""
	The tool '%s' is not configured: %s
""")
LIVE_MIGRATION_PRE_CHECK_TARGET_SERVER_REPORT_TITLE = single_line_message("""
	Target server
""")
LIVE_MIGRATION_CRIU_TOOLS_NOT_INSTALLED_ISSUE = single_line_message("""
	The criu tools are not installed. You must install them to continue migration
""")
LIVE_MIGRATION_MOD_RUID2_NOT_ENABLED_ISSUE = single_line_message("""
	Unable to apply live migration for domain '%s': mod_ruid2 is not enabled. .
""")
LIVE_MIGRATION_MOD_RUID2_NOT_ENABLED_SOLUTION = single_line_message("""
	You must switch on mod_ruid2 in the "Additional directives for HTTP" in Web Server Settings for %s.
""")
ACTION_RESYNC_WEB_FILES_AFTER_LIVE_MIGRATION_DESCRIPTION = single_line_message("""
	Re-sync web content
""")
ACTION_RESYNC_WEB_FILES_AFTER_LIVE_MIGRATION_FAILURE = single_line_message("""
	Failed to re-sync web content
""")
TARGET_PLESK_SERVER_TITLE = single_line_message("""
	target Plesk server
""")
TARGET_PLESK_SERVER_TITLE_WITH_IP = single_line_message("""
	target Plesk server (%s)
""")
CLIENT_MAPPED_TO_RESELLER_THAT_DOES_NOT_EXIST_SOLUTION = single_line_message("""
	Create this reseller in destination panel, or map client to some existing reseller
""")
CUSTOMER_BELONGS_TO_DIFFERENT_OWNER_RESELLER_SOLUTION = single_line_message("""
	Fix migration list so customer belongs to the actual reseller
""")
CLIENT_IS_NOT_LISTED_IN_MIGRATION_LIST = single_line_message("""
	Client '%s' is not listed in migration list, not including it into target model
""")
CREATE_TARGET_MODEL_OBJECTS = single_line_message("""
	Form up target model objects based on migration dumps
""")
SUBSCRIPTION_NOT_LISTED_IN_MIGRATION_LIST = single_line_message("""
	Subscription '%s' is not listed in migration list, not including it into target model
""")
CUSTOMER_BELONGS_TO_DIFFERENT_OWNER_RESELLER_ISSUE = single_line_message("""
	According to migration list customer belongs to %s, but actually on target panel it belongs to another reseller
""")
CUSTOMER_BELONGS_TO_DIFFERENT_OWNER_ADMIN_RESELLER_ISSUE_SOLUTION = single_line_message("""
	Fix migration list so customer belongs to administrator
""")
PLAN_DOES_NOT_EXIST_SOLUTION = single_line_message("""
	Create a service template with this name, or assign subscription to other service template
""")
CUSTOMER_BELONGS_TO_DIFFERENT_OWNER_ADMIN_RESELLER_ISSUE = single_line_message("""
	Customer belongs to administrator on target panel, but according to migration list it belongs to reseller '%s'
""")
RESELLER_TITLE_LOWERCASE = single_line_message("""
	reseller '%s'
""")
PLAN_DOES_NOT_EXIST_ISSUE = single_line_message("""
	{owner} does not have a service template named '{plan_name}', unable to make a subscription on it.
	Subscription will not be transferred.
""")
CONVERT_DUMP = single_line_message("""
	Convert migration dump
""")
CUSTOMER_DOES_NOT_EXIST_ISSUE = single_line_message("""
	Customer '%s' does not exist in source or in destination panel, subscription will not be transferred.
""")
CUSTOMER_DOES_NOT_EXIST_ISSUE_SOLUTION = single_line_message("""
	Create the customer with such login manually, or map subscription to any other existing customer.
""")
CLIENT_MAPPED_TO_RESELLER_THAT_DOES_NOT_EXIST_ISSUE = single_line_message("""
	Client is mapped to an unexisting reseller '%s'
""")
NO_SUCH_ADMIN_RESELLER_PLAN_ISSUE = single_line_message("""
	Reseller plan '%s' specified in migration list file does not exist
""")
NO_SUCH_ADMIN_RESELLER_PLAN_SOLUTION = single_line_message("""
	Fix migration list so existing plan is used, or create reseller plan with such name
""")
ADMIN_RESELLER_PLAN_ON_MULTIPLE_SOURCES_ISSUE = single_line_message("""
	Reseller plan '%s' specified in migration list file exists on multiple source panels.Plan from '%s' will be used
	during migration
""")
LOG_RESELLER_ADMIN_PLAN_ALREADY_EXISTS = single_line_message("""
	Reseller plan '%s' already exists on target panel, it will be used during migration
""")
LOG_CONVERT_SOURCE_PANEL_ADMIN_RESELLER_PLANS = single_line_message("""
	Convert source panel's admin's reseller plans
""")
LOG_MERGE_ADMIN_RESELLER_PLANS = single_line_message("""
	Merge admin's reseller plans
""")
LOG_CONVERT_TARGET_ADMIN_RESELLER_PLANS = single_line_message("""
	Convert target panel admin's reseller plans
""")
LOG_CONVERT_ADMIN_RESELLER_PLANS = single_line_message("""
	Convert admin's reseller plans
""")
SKIPPED_CREATING_EXISTING_AUXILIARY_USER = single_line_message("""
	Skipped creating an existing auxuser '%s'.
""")
USER_PASSWORD_DOES_NOT_MEET_PLESK_REQUIREMENTS = single_line_message("""
	User password does not meet Plesk requirements. A temporary password is generated: '%s'
""")
TARGET_PANEL_PLESK_TITLE = single_line_message("""
	Plesk
""")
UNIX_IMPORT_API_REPAIR_WEBSPACE_NOT_APPLICABLE = single_line_message("""
	Repair webspace security is a Windows-specific function and can not be applied to Plesk for Unix
""")
UNIX_IMPORT_API_REFRESH_NODE_COMPONENTS_NOT_APPLICABLE = single_line_message("""
	Refresh node components is a Windows-specific function and can not be applied to Plesk for Unix
""")
UNIX_IMPORT_API_GET_DEDICATED_APP_POOL_USER_NOT_APPLICABLE = single_line_message("""
	Get dedicated application pool user is a Windows-specific function and can not be applied to Plesk for Unix
""")
UNIX_IMPORT_API_UPDATE_SECURITY_METADATA_LOCATION_NOT_APPLICABLE = single_line_message("""
	Update webspace subdomains security metadata location is a Windows-specific function and can not be applied to Plesk
	for Unix
""")
TARGET_PLESK_VERSION_NOT_SUPPORTED = single_line_message("""
	Migration to Plesk %s is not supported. We strongly recommend that you install Plesk 12.0 or later for migration, or
	upgrade the current installation to the latest version. If you still want to migrate to a Plesk version earlier than
	12.0, use the migration tools bundled with Plesk (not recommended).
""")
UNABLE_TO_FIND_DB_SERVER_ON_TARGET_ISSUE = single_line_message("""
	Unable to find %s database server on target panel
""")
LOG_EXCEPTION = single_line_message("""
	Exception:
""")
SUBSCRIPTION_WAS_ALREADY_CREATED = multi_line_message("""
	Subscription already exists on target server: most probably it was created at the previous attempt,
	but migration tools are not sure if it was created correctly.
	It is recommended to:
	1) Resolve the original issue that caused subscription creation to fail,
	delete subscription, and then run migration again.
	OR
	2) Ensure that created subscription is fine, or the original issue is minor,
	then simply run migration for that subscription again.
""")
ACTION_CHECK_TARGET_LICENSE_LIMIT_DESCRIPTION = single_line_message("""
	Check license limits on target Plesk server
""")
ACTION_CHECK_TARGET_LICENSE_LIMIT_FAILURE = single_line_message("""
	Failed to check license limits on target Plesk server
""")
LOG_DOMAINS_ON_TARGET = single_line_message("""
	Domains on target server: {domains_count}
""")
LOG_LICENSE_LIMIT_ON_TARGET = single_line_message("""
	License limit for domains on target server: {domains_count}
""")
LOG_DOMAINS_ON_SOURCE = single_line_message("""
	Domains on source server: {domains_count}
""")
NOT_ENOUGH_DOMAINS_IN_LICENSE_ISSUE = single_line_message("""
	Target Plesk server license has less available domains that required for migration. Number of available domains
	according to license limitations: {available}. Number of domains we are going to migrate: {required}.
""")
NOT_ENOUGH_DOMAINS_IN_LICENSE_SOLUTION = single_line_message("""
	Obtain and install license on target Plesk server that have more domains available.
""")

UNABLE_TO_FIND_CAPABILITY_CHECK_REPORT = single_line_message("""
	Unable to find capability check report %s
""")
UNABLE_TO_FIND_CAPABILITY_DUMP = single_line_message("""
	Unable to find capability dump %s
""")
ACTION_CHECK_CAPABILITY_DESCRIPTION = single_line_message("""
	Check target panel capability
""")
ACTION_CHECK_CAPABILITY_FAILURE = single_line_message("""
	Failed to check capability of target panel
""")
SYNC_SUBSCRIPTION_WITH_PLAN = single_line_message("""
	Synchronize subscription with plan
""")
FAILED_TO_SYNC_SUBSCRIPTION_WITH_PLAN = single_line_message("""
	Failed to synchronize subscription with plan
""")
CHANGE_NO_VHOSTING_SUBSCRIPTION_WEB_IP_IN_BACKUP = single_line_message("""
	Change web IP addresses in dump for subscription without virtual hosting
""")
FAILED_TO_CHANGE_NO_VHOSTING_SUBSCRIPTION_WEB_IP_IN_BACKUP = single_line_message("""
	Failed to change web IP addresses in dump for subscription without virtual hosting
""")
LOG_WEB_IPS_SET_TO = single_line_message("""
	Subscription '{subscription_name}' web IPs are set to ({ipv4}, {ipv6})
""")
CHECK_MISSING_COMPONENTS_DESCRIPTION = single_line_message("""
	Check for missing Python and Perl components on target Plesk for Windows
""")
CHECK_MISSING_COMPONENTS_FAILURE = single_line_message("""
	Failed to check for missing Python and Perl components on target Plesk for Windows
""")
REMOVE_MISSING_COMPONENTS_DESCRIPTION = single_line_message("""
	Remove missing Python and Perl scripting options from backup dump
""")
REMOVE_MISSING_COMPONENTS_FAILURE = single_line_message("""
	Failed to remove missing Python and Perl scripting options from backup dump
""")
MISSING_COMPONENT_ISSUE = single_line_message("""
	The component {component} is not installed on the destination server. It will be unavailable for
	the following domains: {domains}
""")
MISSING_COMPONENT_SOLUTION = single_line_message("""
	Install that component on the destination server or make sure that none of these
	domains actually need the component.
""")
SUBSCRIPTION_CANNOT_BE_SYNCED_WITH_PLAN_MISSING_COMPONENT = multi_line_message("""
	Subscription cannot be completely synchronized with service plan: the plan has some features enabled which
	can not be activated because some components are not installed. To see which components are missing and how to
	resolve that issue, try to synchronize subscription with service plan in Plesk Panel:
	login to Plesk Panel as administrator, click on subscription, then in "Account" box click "Sync" link.
""")
SERVICE_PLAN_PHP_HANDLER_NOT_AVAILABLE_ISSUE = multi_line_message("""
	Service plan '{plan_name}' on source server has PHP handler
	that is not installed on the target server: {source_php_handler}.
	Another PHP handler was selected for that service template: {target_php_handler}
""")
SERVICE_PLAN_PHP_HANDLER_NOT_AVAILABLE_SOLUTION = multi_line_message("""
	To resolve the issue, it is recommended to do one of the following:
	- Install and enable such PHP handler to target server.
	- Ensure that PHP handler that was selected automatically is fine for migrated web sites.
	- Select appropriate PHP handler in service template once migration is finished
	and synchronize the changes to subscriptions.
""")

ADDON_PLAN_DOES_NOT_EXIST_ISSUE = single_line_message("""
	{owner} does not have an addon plan named '{plan_name}', unable to make a subscription on it.
	Subscription will not be transferred.
""")
ADDON_PLAN_DOES_NOT_EXIST_SOLUTION = single_line_message("""
	Create an addon plan with this name, or assign subscription to other addon plan, or remove addon plan from
	the migration list file
""")
IP_MAPPING_NO_SUCH_IP_SOLUTION = single_line_message("""
	Either add such IP address to the target Plesk server,
	or migrate subscription to another address by specifying '%s: <ip>' in the migration list.
	Also you can change IP address after migration is finished.
""")
IP_MAPPING_IP_ASSIGNED_TO_ANOTHER_OWNER_SOLUTION = single_line_message("""
	Migrate subscription to another address by specifying '%s: <ip>' in the migration list.
	Also you can change IP address after migration is finished.
""")
IP_MAPPING_NO_MORE_EXCLUSIVE_IP_ISSUE = single_line_message("""
	There is not enough free exclusive %s addresses on target Plesk to map all source exclusive IP addresses.
	This subscription will be migrated to default shared IP address
""")
IP_MAPPING_NO_MORE_EXCLUSIVE_IP_SOLUTION = single_line_message("""
	Add more free exclusive IP addresses to target panel
	or change IP addresses of migrated subscriptions after migration
""")
IP_MAPPING_NO_FREE_EXCLUSIVE_IP_SOLUTION = single_line_message("""
	To migrate subscription to exclusive %s, add more free exclusive IP addresses on the target Plesk server.
	Also you can change IP address after migration is finished.
""")
IP_MAPPING_NO_SHARED_IP_ISSUE = single_line_message("""
	There is no shared %s address on target Plesk. Subscription can not be migrated.
""")
IP_MAPPING_NO_SUCH_IP_ISSUE = single_line_message("""
	Subscription is assigned to %s address '%s' which does not exist on the target Plesk server.
	Subscription will be migrated to default shared IP.
""")
IP_MAPPING_NO_FREE_EXCLUSIVE_IP_ISSUE = single_line_message("""
	Subscription is assigned to exclusive IP address, but there are no free exclusive IP addresses left.
	Subscription will be migrated to default shared IP address.
""")
IP_MAPPING_NO_SHARED_IP_SOLUTION = single_line_message("""
	Fix Plesk configuration so there is at least one shared %s address
""")
IP_MAPPING_IP_ASSIGNED_TO_ANOTHER_OWNER_ISSUE = single_line_message("""
	Subscription is assigned to %s address '%s' which is also assigned to another reseller/client.
	Subscription will be migrated to default shared IP.
""")
ACTION_SET_APACHE_RESTART_INTERVAL = single_line_message("""
	Set Apache restart interval
""")
MIGRATION_TOOL_DETECTED_THAT_OLD_APACHE = single_line_message("""
	The migration tool has detected that the old Apache restart interval was not completely restored, probably because
	the tool was terminated abnormally. The tool will restore this interval (%s) upon completing the transfer.
""")
SET_APACHE_RESTART_INTERVAL_S_SECONDS = single_line_message("""
	Set Apache restart interval to %s seconds
""")
ACTION_CONVERT_DNS_RECORDS = single_line_message("""
	Convert DNS records
""")
IP_MAPPING_ASSIGNED_DEFAULT_IP = single_line_message("""
	Assigned a default shared IP address '%s' to the subscription '%s'
""")
IP_MAPPING_SUBSCRIPTION_ASSIGNED_IPS = single_line_message("""
	Subscription IP is set to ("%s", "%s"), as specified in the migration list.
""")
FAILED_TO_ADD_IP_TO_RESELLER_POOL = single_line_message("""
	Failed to add IP address '%s' to IP pool of reseller '%s':
	ip_pool utility returned non-zero exit code. Utility stdout: %s, stderr: %s"
""")
ACTION_IMPORT_RESELLERS = single_line_message("""
	Import resellers
""")
FAILED_SET_APACHE_RESTART_INTERVAL_VALUE = single_line_message("""
	Failed to set Apache restart interval value to %s seconds
""")

IMPORT_CREATE_CLIENT_SET_LOCALE_FAILED = single_line_message("""
	Failed to set locale {locale}: {error}
""")