import posixpath 
from parallels.core.connections.source_server import SingleServerPanelSourceServer

class ConfixxSourceServer(SingleServerPanelSourceServer):
	def __init__(self, node_id, node_settings, confixx_configuration):
		super(SingleServerPanelSourceServer, self).__init__(
				node_id, node_settings
		)
		self.confixx_configuration = confixx_configuration

	def get_unix_vhost_dirs(self, runner, domain_name):
		"""Return list of directories with domain hosting content."""
		return [self.confixx_configuration.get_domain_vhost_dir(domain_name)]

	def get_unix_domain_mail_dirs(self, runner, domain_name):
		"""Return list of directories with system domain mail content.
		
		In Confixx, mail directories/mailboxes are named this way:
			<client id>p<mail user number>
		, for example:
			web123p44
		"""
		mail_wildcard = u"%sp*" % posixpath.join(
				self.confixx_configuration.get_mailbox_root(),
				self.confixx_configuration.get_client_id(domain_name)
		)
		_, mail_dirs, _ = runner.sh_unchecked(
				u'ls -d %s' % mail_wildcard
		)
		return mail_dirs.split('\n')
