from parallels.plesk.source.cpanel import messages
from parallels.core.actions.base.legacy_action \
	import LegacyAction
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.source.cpanel.actions.content.web.copy_unix_content \
	import CpanelCopyUnixWebContent
from parallels.plesk.source.cpanel.actions.content.web.fix_unix_htaccess \
	import FixUnixHtaccess
from parallels.core.actions.content.web.fix_unix_vhost_permissions \
	import FixUnixVhostPermissions
from parallels.plesk.source.cpanel.actions.content.web.fix_unix_permissions \
	import FixUnixPermissions
from parallels.plesk.actions.hosting_settings.convert.dns \
	import DNS as ActionHostingSettingsConvertDNS


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with source-panel specific actions

		:type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
		"""
		workflow.get_shared_action('convert-hosting').replace(
			'convert-dns', ActionHostingSettingsConvertDNS()
		)
		workflow.get_shared_action('fetch-source').insert_action(
			'fetch-data', LegacyAction(
				description=messages.ACTION_FETCH_SOURCE,
				function=lambda ctx: ctx.migrator._fetch_source(
					ctx.options, ctx.options.reload_source_data
				)
			)
		)
		workflow.get_shared_action('copy-web-files').insert_action(
			'copy-files', CpanelCopyUnixWebContent()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'fix-unix-htaccess', FixUnixHtaccess()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'fix-unix-vhost-permissions', FixUnixVhostPermissions()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions', FixUnixPermissions()
		)
