from contextlib import contextmanager
from parallels.plesk.utils.xml_rpc.plesk.operator import IpAddressInfo

from parallels.plesk.connections.target_server import PleskTargetServer
from parallels.core.utils.common import cached
from parallels.shm_web_sn import messages


class PPAMoveWebspacesTargetServer(PleskTargetServer):

	def description(self):
		return messages.TARGET_PPA_WEB_SN

	@contextmanager
	def runner(self):
		with self.conn.main_node_runner() as runner:
			yield runner

	@property
	def plesk_version(self):
		return 12, 1

	@cached
	def get_all_ips(self, global_context):
		ips = []
		if global_context.webspace_ipv4 is not None:
			ips.append(IpAddressInfo(
				ip_address=global_context.webspace_ipv4,
				ip_type=global_context.webspace_ipv4_type,
				public_ip_address=global_context.webspace_ipv4
			))
		if global_context.webspace_ipv6 is not None:
			ips.append(IpAddressInfo(
				ip_address=global_context.webspace_ipv6,
				ip_type=global_context.webspace_ipv6_type,
				public_ip_address=global_context.webspace_ipv6
			))
		return ips