"""This module defines path to migrator's thirdpary utils for Windows"""

import os
import parallels.common

from parallels.utils import is_run_on_windows

def get_paexec_bin():
	"""Location of paexec.exe - utility to run commands on remote Windows"""
	return os.path.join(get_thirdparty_dir(), "paexec.exe")

def get_rsync_bin():
	"""Location of rsync.exe - utility to download files from remote server"""
	return os.path.join(get_thirdparty_dir(), "rsync/rsync.exe")

def get_rsync_for_source_server_installer():
	"""Get installer binary for rsync on source servers"""
	return os.path.join(get_thirdparty_dir(), "rsync-for-source-server.exe")

def get_thirdparty_dir():
	if is_run_on_windows():
		current_file_dir = os.path.dirname(__file__)
		# 5 times up - according to Windows layout
		path_elems = [current_file_dir] + [r'..'] * 5 + ['thirdparty']
		return os.path.realpath(os.path.join(*path_elems))
	else:
		return os.path.join(_get_common_root_path(), 'extras')

def _get_common_root_path():
	# Get path to package root directory.
	dirs = [p for p in parallels.common.__path__]
	assert all(d == dirs[0] for d in dirs)
	return dirs[0]
