from parallels.common.actions.base.common_action import CommonAction
from parallels.common import MigrationError


class UndoDNSForwardingNotSupported(CommonAction):
	def get_description(self):
		return "Check if source panel supports DNS forwarding"

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return "Failed to check if source panel supports DNS forwarding"

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		raise MigrationError(
			u"DNS forwarding is not supported for this type of migration. "
			u"Switch IP addresses of DNS servers manually at registar."
		)
