from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import ServiceIssueType

MESSAGES = {}

MESSAGES[ServiceIssueType.SERVICE_NOT_STARTED] = format_message("""
Make sure that the service is started.
""")

MESSAGES[ServiceIssueType.SERVICE_PORT_IS_CLOSED] = format_message("""
1) Check that service is up
2) Check that there are no firewall rules that may block connection to the service
""")

MESSAGES[ServiceIssueType.SERVICE_CONNECTION_ERROR] = format_message("""
Most probably the issue is caused by firewall configuration.
""")

MESSAGES[ServiceIssueType.SERVICE_INTERNAL_ERROR] = format_message("""
Check that the service is started and port is available.
""")
