from parallels.common.actions.base.common_action import CommonAction
from parallels.common import MigrationError


class ImportPlansNotSupported(CommonAction):
	def get_description(self):
		return "Check if target panel supports plans import"

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return "Failed to check if target panel supports plans import"

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		raise MigrationError(
			u"Service plans (service templates) import is not supported for current target panel. "
			u"Create plans (templates) manually before starting subscription transfer."
		)