import tarfile
import StringIO

def tar_add_file_content(tar, content, filename):
	tarinfo = tarfile.TarInfo(filename)
	source = StringIO.StringIO(content)
	tarinfo.size = len(source.getvalue())
	tar.addfile(tarinfo, source)

def tar_add_empty_file(tar, filename):
	tarinfo = tarfile.TarInfo(filename)
	tarinfo.size = 0
	tar.addfile(tarinfo)

def tar_add_dir(tar, dirname):
	tarinfo = tarfile.TarInfo(dirname)
	tarinfo.type = tarfile.DIRTYPE
	tar.addfile(tarinfo)

