#!/usr/bin/perl
# Copyright 1999-2014. Parallels IP Holdings GmbH. All Rights Reserved.
# 
# For each given Confixx client, provide mapping from his subscription's email
# addresses to mailbox filenames.
#
# Read mail user names from STDIN; print tab-separated pairs of
# <email>, <mailbox filename> 
# 
# Usage example:
# $ echo web0 | perl -Ishared_legacy mailmapping.pl
# web0p1@web0.migration1.test   web0p1
# webmaster1@res0user0d1.tld    web0p3
#
# Function 'Agent::_mappingMailUsers($_)' returns a hash in format
# { 
#	'domain1' -> { 'mailuser1' -> mbox1, 'mailuser2' -> mbox2, ... }
#	'domain1' -> { 'mailuser1' -> mbox1, ...}
#	...
# }

use lib '.';
use Agent;

$| = 1;
while (<>) {
    chomp;
    my $mailmapping = Agent::_mappingMailUsers($_);
    for $domain (keys%{$mailmapping}) {
        my $mailusers = $mailmapping->{$domain};
        for $mailuser (keys%{$mailusers}) {
			print"$mailuser\@$domain\t${$mailmapping}{$domain}{$mailuser}{'mbox'}\n"
        }
    };
}
