from collections import namedtuple

from parallels.common.utils.yaml_utils import pretty_yaml

# namedtuple with pretty YAML serialization
def _nt(*args):
	return pretty_yaml(namedtuple(*args), prefix='expand')

Model = _nt('Model', ('servers', 'centralized_mail_servers', 'expand_clients', 'plesk_clients', 'expand_resellers', 'assigned_plesk_clients', 'plesk_domains', 'plesk_domain_aliases', 'expand_plans'))
ExpandClient = _nt('ExpandClient', ('id', 'info', 'personal_info'))
PleskClient = _nt('PleskClient', (
		'id', 'login', 'pname', 'plesk_id',
		'expand_client_id', # should be None if Plesk client is not owned by any Expand client
	)
)
Server = _nt('Server', ('id', 'name', 'plesk_id'))
CentralizedMailServer = _nt('CentralizedMailServer', ('id', 'ip', 'plesk_id', 'assigned_server_ids'))
# TODO rename to ExpandReseller
ExpandResellers = _nt('ExpandResellers', ('id', 'login', 'email', 'name', 'password', 'locale', 'is_active', 
'limits', 'permissions', 'plan_id')) 
AssignedPleskClient = _nt('AssignedPleskClient', ('client_id', 'reseller_id', 'assignee_id', 'assignee_type'))
PleskDomain = _nt('PleskDomain', ('id', 'name', 'client_id', 'plesk_id', 'tmpl_id', 'tmpl_name'))
PleskDomainAlias = _nt('PleskDomainAlias', ('id', 'name'))
ExpandPlan = _nt('ExpandPlan', ('id', 'reseller_id', 'name'))
