from parallels.common.actions.base.subscription_action import SubscriptionAction
from parallels.common.actions.hosting_settings.import_backups import ImportedBackups
from parallels.common.utils.restore_hosting_utils import get_restore_hosting_utils


class RestoreApplications(SubscriptionAction):
	def get_description(self):
		return "Restore APS applications"

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return "Failed to restore APS applications settings for subscription '%s'" % (
			subscription.name
		)

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed for a subscription, migration tool
		won't run the next operations for the subscription.

		:rtype: bool
		"""
		return False

	def filter_subscription(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return subscription.converted_backup.has_aps

	def run(self, global_context, subscription):
		"""Restore APS applications after copy web content so all configs updated according to new configuration.

		For example, if database server's IP has been changed, wp-config.php file of Wordpress APS application should 
		be updated accordingly. We should do this after copy-content step, otherwise configuration
		files are overwritten by copy-content step.

		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		imported_backup = ImportedBackups.get_instance().get_by_backup(subscription.full_converted_backup)
		subscription_backup_xml = imported_backup.get_domain_xml_path(subscription.name)

		restore_hosting_utils = get_restore_hosting_utils(subscription.panel_target_server)
		restore_hosting_utils.restore_hosting_settings(
			subscription.name, subscription_backup_xml, global_context.safe,
			settings_description=u"APS applications",
			restore_siteapps_only=True
		)