from contextlib import contextmanager
from parallels.common.utils import unix_utils
from parallels.utils import cached


class UnixServer(object):
	@property
	@cached
	def is_centos(self):
		with self.runner() as runner:
			return unix_utils.is_centos(runner)

	@property
	@cached
	def is_debian(self):
		with self.runner() as runner:
			return unix_utils.is_debian(runner)

	@property
	@cached
	def is_suse(self):
		with self.runner() as runner:
			return unix_utils.is_suse(runner)

	@property
	@cached
	def apache_user(self):
		if self.is_debian:
			return 'www-data'
		elif self.is_suse:
			return 'wwwrun'
		else:
			return 'apache'

	@property
	@cached
	def apache_group(self):
		if self.is_debian:
			return 'www-data'
		elif self.is_suse:
			return 'www'
		else:
			return 'apache'

	@contextmanager
	def runner(self):
		"""Get runner object to execute commands on the source server"""
		raise NotImplementedError()