from collections import namedtuple

from parallels.expand_api.core import parse_result_set
from parallels.utils.xml import elem

PleskMailServerInfo = namedtuple('PleskMailServerInfo', ('id', 'ip', 'port', 'cp_login', 'cp_password', 'assigned_server_ids'))


class PleskMailServerOperator(object):
	class Get(namedtuple('Get', ('filter',))):
		class FilterAll(object):
			def inner_xml(self):
				return []

		operator_name = 'exp_plesk_mail_server'
		operation_name = 'get'

		def inner_xml(self):
			return [
				elem('filter', self.filter.inner_xml()),
			]
			
		@classmethod
		def parse(cls, elem):
			return parse_result_set(elem, cls._parse_data)

		@classmethod
		def _parse_data(cls, elem):
			return PleskMailServerInfo(
				id=int(elem.findtext('id')),
				ip=elem.findtext('data/ip'),
				port=int(elem.findtext('data/port')),
				cp_login=elem.findtext('data/cp_login'),
				cp_password=elem.findtext('data/cp_password'),
				assigned_server_ids=[int(e.text) for e in elem.findall('data/server_id')]
			)

