Jsw.onReady(function() {
    var radioAutomaticDeploy = $('sourceServer-sourceRPCAgentDeployMode-automatic');
    var radioManualDeploy = $('sourceServer-sourceRPCAgentDeployMode-manual');

    function updateRPCAgentDeployType()
    {
        if (radioAutomaticDeploy.checked) {
            $('sourceServer-sourceWindowsLogin-form-row').show();
            $('sourceServer-sourceWindowsPassword-form-row').show();
            $('sourceServer-rpcAgentDownload-form-row').hide();
        } else {
            $('sourceServer-sourceWindowsLogin-form-row').hide();
            $('sourceServer-sourceWindowsPassword-form-row').hide();
            $('sourceServer-rpcAgentDownload-form-row').show();
        }
    }

    // Special handling for Helm 3, for which we should specify login and password of Helm administrator Windows
    // user (instead of built-in Windows administrator as we do it for all the other panels).
    function panelTypeChanged() {
        var elemInputLogin = $('sourceServer-sourceWindowsLogin');
        var sourcePanel = $$('input:checked[type=radio][name="sourceServer[sourcePanelType]"]').first().value;
        var elemLabelLogin = $$('label[for="sourceServer-sourceWindowsLogin"]').first().childNodes[0];
        var elemLabelPassword = $$('label[for="sourceServer-sourceWindowsPassword"]').first().childNodes[0];

        if (sourcePanel == 'helm3') {
            if ('Administrator' == elemInputLogin.value) {
                elemInputLogin.value = 'HELM_ADMIN';
            }

            elemLabelLogin.nodeValue = MESSAGE_LABEL_HELM_ADMIN_LOGIN + ' ';
            elemLabelPassword.nodeValue = MESSAGE_LABEL_HELM_ADMIN_PASSWORD + ' ';
        } else {
            if ('HELM_ADMIN' == elemInputLogin.value) {
                elemInputLogin.value = 'Administrator';
            }

            elemLabelLogin.nodeValue = MESSAGE_LABEL_BUILT_IN_ADMIN_LOGIN + ' ';
            elemLabelPassword.nodeValue = MESSAGE_LABEL_BUILT_IN_ADMIN_PASSWORD + ' ';
        }
    }

    radioAutomaticDeploy.observe('change', updateRPCAgentDeployType);
    radioManualDeploy.observe('change', updateRPCAgentDeployType);

    updateRPCAgentDeployType();

    $$('input[name="sourceServer[sourcePanelType]"]').each(function(elem) {
        elem.observe('change', panelTypeChanged);
    });
});