
// Show popup dialog with confirmation to cancel migration of subscriptions (remove them from queue).
// Arguments: subscriptions - list of subscription names.
// - onSuccess - function that will be called once cancel of these subscriptions is performed.
function showCancelPopup(subscriptions, onSuccess) {
    Jsw.messageBox.show({
        'type': Jsw.messageBox.TYPE_YESNO,
        'subtype': 'delete',
        'text': MESSAGE_POPUP_CANCEL_DESCRIPTION,
        'onYesClick': function () {
            new Ajax.Request(URL_CANCEL_SUBSCRIPTIONS, {
                parameters: {
                    subscriptions: Object.toJSON(subscriptions)
                },
                onSuccess: function() {
                    if (onSuccess) {
                        onSuccess();
                    }
                }
            });
        },
        'buttonTitles': {
            'yes': MESSAGE_POPUP_CANCEL_BUTTON_YES,
            'no': MESSAGE_POPUP_CANCEL_BUTTON_NO
        }
    });
}
