
function showPreChecksPopup(taskId, proceedToMigrationIfNoIssues) {
    var skipChecks = false;
    var skipChecksFinished = false;

    var popup = new Jsw.Popup({
        title: migratorLocale.lmsg('preMigrationChecksTitle'),
        content: (
            '<div style="margin-bottom: 10px;">' +
                '<span id="pre-checks-action-text">' +
                    migratorLocale.lmsg('preMigrationChecksStarting') +
                '</span>' +
                '<span id="pre-checks-error-text" style="display: none">' +
                '</span>' +
            '</div>' +
            '<div class="migrator-progress-bar" id="pre-checks-progress-bar">' +
            '<div class="migrator-progress-bar-wrap">' +
                '<div style="width: 100%;" class="migrator-progress-bar-fill"><span></span></div>' +
            '</div>' +
            '</div>'
        ),
        buttons: [
            {
                id: 'pre-check-skip-button',
                title: migratorLocale.lmsg('preMigrationChecksSkipButton'),
                handler: function (event, popup) {
                    skipChecks = true;

                    var skipButton = $('pre-check-skip-button');
                    var inBackgroundButton = $('pre-check-in-background');
                    skipButton.up().addClassName('disabled');
                    inBackgroundButton.up().addClassName('disabled');
                    skipButton.disabled = true;
                    inBackgroundButton.disabled = true;
                    skipButton.update(
                        '<span class="wait">' + migratorLocale.lmsg('waitButtonTitle') + '</span>'
                    );

                    elemActionText.update(migratorLocale.lmsg('preMigrationChecksCancelling'));
                    new Ajax.Request(URL_CANCEL_PRE_CHECKS + '/task/' + taskId, {
                        onSuccess: function() {
                            skipChecksFinished = true;
                        }
                    });
                }
            },
            {
                id: 'pre-check-in-background',
                title: migratorLocale.lmsg('preMigrationChecksInBackgroud'),
                handler: function(event, popup) {
                    var skipButton = $('pre-check-skip-button');
                    var inBackgroundButton = $('pre-check-in-background');
                    skipButton.up().addClassName('disabled');
                    inBackgroundButton.up().addClassName('disabled');
                    skipButton.disabled = true;
                    inBackgroundButton.disabled = true;
                    inBackgroundButton.update(
                        '<span class="wait">' + migratorLocale.lmsg('waitButtonTitle') + '</span>'
                    );

                    Jsw.redirect(URL_MIGRATION_STATUS);
                }
            }
        ],
        popupCls: 'popup-panel popup-panel-centered'
    });

    popup.show();

    var elemActionText = $('pre-checks-action-text');

    function pollProgress() {
        new Ajax.Request(URL_GET_PROGRESS_PRE_CHECKS + '/task/' + taskId, {
            onSuccess: function (response) {
                var progress = response.responseText.evalJSON();

                if (
                    progress.status == overallStatus.FINISHED_OK ||
                    progress.status == overallStatus.FINISHED_WARNINGS ||
                    progress.status == overallStatus.FINISHED_ERRORS
                ) {
                    if (skipChecks) {
                        new Ajax.Request(URL_START_MIGRATION + '/task/' + taskId, {
                            onSuccess: function (response) {
                                Jsw.redirect(URL_MIGRATION_STATUS);
                            }
                        });

                        return;
                    }

                    if (proceedToMigrationIfNoIssues) {
                        elemActionText.update(migratorLocale.lmsg('preMigrationChecksFinishedCheckIssues'));
                        new Ajax.Request(URL_HAS_PRE_MIGRATION_ISSUES + '/task/' + taskId, {
                            onSuccess: function (response) {
                                var hasPreMigrationIssues = response.responseText.evalJSON();
                                if (hasPreMigrationIssues) {
                                    elemActionText.update(migratorLocale.lmsg('preMigrationChecksFinishedCheckIssues'));
                                    Jsw.redirect(URL_PRE_MIGRATION_CHECK_RESULTS + '/task/' + taskId);
                                } else {
                                    elemActionText.update(migratorLocale.lmsg('preMigrationChecksFinishedStartingMigration'));
                                    new Ajax.Request(URL_START_MIGRATION + '/task/' + taskId, {
                                        onSuccess: function (response) {
                                            Jsw.redirect(URL_MIGRATION_STATUS);
                                        }
                                    });
                                }
                            }
                        });
                    } else {
                        elemActionText.update(migratorLocale.lmsg('preMigrationChecksFinishedRedirecting'));
                        Jsw.redirect(URL_PRE_MIGRATION_CHECK_RESULTS + '/task/' + taskId);
                    }
                } else if (!progress.status && skipChecksFinished) {
                    new Ajax.Request(URL_START_MIGRATION + '/task/' + taskId, {
                        onSuccess: function (response) {
                            Jsw.redirect(URL_MIGRATION_STATUS);
                        }
                    });
                } else {
                    if (!skipChecks) {
                        if (progress.action) {
                            elemActionText.update(formatStr(progress.action));
                        } else if (progress.status == null) {
                            elemActionText.update(migratorLocale.lmsg('preMigrationChecksWaitingForTasks'))
                        }
                    }

                    // Poll progress once more
                    setTimeout(pollProgress, PRE_CHECKS_POLL_INTERVAL);
                }
            }
        });
    }

    pollProgress();
}