// Identifiers of operations that we could perform on subscriptions
subscriptionOperation = {
    MIGRATE: 'Migrate',
    RESTART: 'Restart',
    SWITCH_DNS: 'SwitchDns',
    REASSIGN_OWNER: 'ReassignOwner',
    REASSIGN_PLAN: 'ReassignPlan',
    RESET_REASSIGN: 'ResetReassign',
    CHANGE_IP_MAPPING: 'ChangeIpMapping',
    RESYNC: 'Resync',
    POST_MIGRATION_CHECKS: 'PostMigrationChecks',
    REVERT_DNS: 'RevertDns',
    REMOVE_FROM_QUEUE: 'RemoveFromQueue',
    REMOVE_MIGRATED: 'RemoveMigrated'
    // TODO: implement support
    /* SHOW_LOG: 'ShowLog' */
};

// Descriptions of operations that we could perform on subscriptions
var subscriptionOperations = [];

subscriptionOperations.push({
    name: subscriptionOperation.MIGRATE,
    run: function(subscriptionNames, onSuccess) {
        showMigratePopup(subscriptionNames, onSuccess);
    },
    isApplicable: function(subscriptionInfo) {
        return !_isRunningOrQueued(subscriptionInfo);
    },
    isMain: function(subscriptionInfo) {
        var migrationStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.MIGRATION], statuses.NOT_STARTED
        );
        return inArray(migrationStatus, [statuses.NOT_STARTED, statuses.CANCELLED]);
    },
    titleMain:  'subscriptionsListActionMigrate',
    titleGroupOperation: 'subscriptionsListButtonMigrateTitle',
    descriptionGroupOperation: 'subscriptionsListButtonMigrateHint',
    listReload: false
});

subscriptionOperations.push({
    name: subscriptionOperation.RESTART,
    run: function(subscriptionNames, onSuccess) {
        showMigratePopup(subscriptionNames, onSuccess);
    },
    isApplicable: function(subscriptionInfo) {
        return !_isRunningOrQueued(subscriptionInfo);
    },
    titleMain:  'subscriptionsListActionRestart',
    isMain: function(subscriptionInfo) {
        var migrationStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.MIGRATION], statuses.NOT_STARTED
        );
        return migrationStatus == statuses.FINISHED_ERRORS && !_isRunningOrQueued(subscriptionInfo);
    },
    listReload: false
});

subscriptionOperations.push({
    name: subscriptionOperation.SWITCH_DNS,
    run: function(subscriptionNames, onSuccess) {
        showSwitchDNSPopup(subscriptionNames, onSuccess);
    },
    isApplicable: function(subscriptionInfo) {
        var migrationStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.MIGRATION], statuses.NOT_STARTED
        );
        var switchDNSStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.DNS_SWITCH], statuses.NOT_STARTED
        );
        return (
            (
                migrationStatus == subscriptionStatus.FINISHED_OK ||
                migrationStatus == subscriptionStatus.FINISHED_WARNINGS
            ) &&
            (
                switchDNSStatus == subscriptionStatus.NOT_STARTED ||
                switchDNSStatus == subscriptionStatus.CANCELLED ||
                switchDNSStatus == subscriptionStatus.REVERTED
            ) && !_isRunningOrQueued(subscriptionInfo)
        );
    },
    isMain: function(subscriptionInfo) { return false; },
    titleGroupOperation: 'subscriptionsListButtonSwitchDnsTitle',
    descriptionGroupOperation: 'subscriptionsListButtonSwitchDnsHint',
    titleMenu: 'subscriptionActionSwitchDns',
    listReload: false
});

subscriptionOperations.push({
    name: subscriptionOperation.REASSIGN_OWNER,
    run: function(subscriptionNames, onSuccess) {
        showReassignOwnerPopup(subscriptionNames, onSuccess);
    },
    isApplicable: function(subscriptionInfo) {
        var migrationStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.MIGRATION], statuses.NOT_STARTED
        );
        return inArray(migrationStatus, [subscriptionStatus.NOT_STARTED, subscriptionStatus.CANCELLED]);
    },
    isMain: function(subscriptionInfo) { return false; },
    titleGroupOperation: 'subscriptionsListButtonReassignOwnerTitle',
    descriptionGroupOperation: 'subscriptionsListButtonReassignOwnerHint',
    titleMenu: 'subscriptionActionReassignOwner',
    listReload: true
});

subscriptionOperations.push({
    name: subscriptionOperation.REASSIGN_PLAN,
    run: function(subscriptionNames, onSuccess) {
        showReassignPlanPopup(subscriptionNames, onSuccess);
    },
    isApplicable: function(subscriptionInfo) {
        var migrationStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.MIGRATION], statuses.NOT_STARTED
        );
        return inArray(migrationStatus, [subscriptionStatus.NOT_STARTED, subscriptionStatus.CANCELLED]);
    },
    isMain: function(subscriptionInfo) { return false; },
    titleGroupOperation:  'subscriptionsListButtonReassignPlanTitle',
    descriptionGroupOperation:  'subscriptionsListButtonReassignPlanHint',
    titleMenu: 'subscriptionActionReassignPlan',
    listReload: true
});

subscriptionOperations.push({
    name: subscriptionOperation.RESET_REASSIGN,
    run: function(subscriptionNames, onSuccess) {
        new Ajax.Request(URL_RESET_REASSIGN_SUBSCRIPTIONS, {
            parameters: {
                subscriptions: Object.toJSON(subscriptionNames)
            },
            onSuccess: function (response) {
                onSuccess();
            }
        });
    },
    isApplicable: function(subscriptionInfo) {
        var migrationStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.MIGRATION], statuses.NOT_STARTED
        );
        return inArray(migrationStatus, [subscriptionStatus.NOT_STARTED, subscriptionStatus.CANCELLED]);
    },
    isMain: function(subscriptionInfo) { return false; },
    titleGroupOperation: 'subscriptionsListButtonResetReassignTitle',
    descriptionGroupOperation: 'subscriptionsListButtonResetReassignHint',
    titleMenu: 'subscriptionActionReassignReset',
    listReload: true
});

subscriptionOperations.push({
    name: subscriptionOperation.CHANGE_IP_MAPPING,
    run: function(subscriptionNames, onSuccess) {
        showChangeIPPopup(subscriptionNames, onSuccess);
    },
    isApplicable: function(subscriptionInfo) {
        var migrationStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.MIGRATION], statuses.NOT_STARTED
        );
        return inArray(migrationStatus, [subscriptionStatus.NOT_STARTED, subscriptionStatus.CANCELLED]);
    },
    isMain: function(subscriptionInfo) { return false; },
    titleGroupOperation: 'subscriptionsListButtonChangeIpMappingTitle',
    descriptionGroupOperation: 'subscriptionsListButtonChangeIpMappingHint',
    titleMenu: 'subscriptionActionChangeIpMapping',
    listReload: true,
    showIPMapping: true
});

subscriptionOperations.push({
    name: subscriptionOperation.RESYNC,
    run: function(subscriptionNames, onSuccess) {
        showResyncPopup(subscriptionNames, onSuccess);
    },
    isApplicable: function(subscriptionInfo) {
        var migrationStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.MIGRATION], statuses.NOT_STARTED
        );
        return (
            migrationStatus != statuses.NOT_STARTED && migrationStatus != statuses.CANCELLED &&
            !_isRunningOrQueued(subscriptionInfo)
        );
    },
    isMain: function(subscriptionInfo) {
        var migrationStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.MIGRATION], statuses.NOT_STARTED
        );
        var switchDNSStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.DNS_SWITCH], statuses.NOT_STARTED
        );
        return (
            (
                migrationStatus == statuses.FINISHED_OK ||
                migrationStatus == statuses.FINISHED_WARNINGS ||
                switchDNSStatus == statuses.FINISHED_OK ||
                switchDNSStatus == statuses.FINISHED_WARNINGS ||
                switchDNSStatus == statuses.REVERTED
            ) && !_isRunningOrQueued(subscriptionInfo)
        );
    },
    titleMain: 'subscriptionsListActionResync',
    titleGroupOperation: 'subscriptionsListButtonResyncTitle',
    descriptionGroupOperation: 'subscriptionsListButtonResyncHint'
});

subscriptionOperations.push({
    name: subscriptionOperation.POST_MIGRATION_CHECKS,
    run: function(subscriptionNames, onSuccess) {
        showPostMigrationChecksPopup(subscriptionNames, onSuccess);
    },
    isApplicable: function(subscriptionInfo) {
        var migrationStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.MIGRATION], statuses.NOT_STARTED
        );
        return (
            migrationStatus != statuses.NOT_STARTED && migrationStatus != statuses.CANCELLED &&
            !_isRunningOrQueued(subscriptionInfo)
        );
    },
    isMain: function(subscriptionInfo) { return false; },
    titleGroupOperation: 'subscriptionsListButtonPostMigrationChecksTitle',
    descriptionGroupOperation: 'subscriptionsListButtonPostMigrationChecksHint',
    titleMenu: 'subscriptionActionRunPostMigrationChecks'
});

subscriptionOperations.push({
    name: subscriptionOperation.REVERT_DNS,
    run: function(subscriptionNames, onSuccess) {
        showRevertDnsPopup(subscriptionNames, onSuccess);
    },
    isApplicable: function(subscriptionInfo) {
        var switchDnsStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.DNS_SWITCH], statuses.NOT_STARTED
        );
        return (
            (
                switchDnsStatus == statuses.FINISHED_OK ||
                switchDnsStatus == statuses.FINISHED_WARNINGS
            ) && !_isRunningOrQueued(subscriptionInfo)
        );
    },
    isMain: function(subscriptionInfo) { return false; },
    titleGroupOperation: 'subscriptionsListButtonRevertDnsTitle',
    descriptionGroupOperation: 'subscriptionsListButtonRevertDnsHint',
    titleMenu: 'subscriptionActionRevertDns'
});

subscriptionOperations.push({
    name: subscriptionOperation.REMOVE_FROM_QUEUE,
    run: function(subscriptionNames, onSuccess) {
        showCancelPopup(subscriptionNames, onSuccess);
    },
    isApplicable: function(subscriptionInfo) {
        return _isRunningOrQueued(subscriptionInfo);
    },
    isMain: function(subscriptionInfo) {
        return _isRunningOrQueued((subscriptionInfo));
    },
    titleMain: 'subscriptionsListActionCancel',
    titleGroupOperation: 'subscriptionsListButtonRemoveFromQueueTitle',
    descriptionGroupOperation: 'subscriptionsListButtonRemoveFromQueueHint'
});

subscriptionOperations.push({
    name: subscriptionOperation.REMOVE_MIGRATED,
    run: function(subscriptionNames, onSuccess) {
        showRemovePopup(subscriptionNames, onSuccess);
    },
    isApplicable: function(subscriptionInfo) {
        var migrationStatus = getPropertyChain(
            subscriptionInfo, ['operationStatus', subscriptionStatusOperation.MIGRATION], statuses.NOT_STARTED
        );
        return (
            migrationStatus != statuses.NOT_STARTED && migrationStatus != statuses.CANCELLED &&
            !_isRunningOrQueued(subscriptionInfo)
        );
    },
    isMain: function(subscriptionInfo) { return false; },
    titleGroupOperation: 'subscriptionsListButtonRemoveMigratedTitle',
    descriptionGroupOperation: 'subscriptionsListButtonRemoveMigratedHint'
});

// TODO: implement support
/*
subscriptionOperations.push({
    name: subscriptionOperation.SHOW_LOG,
    run: function(subscriptionNames, onSuccess) {
    },
    isApplicable: function(subscriptionInfo) {
        return subscriptionInfo.status != subscriptionStatus.NOT_STARTED;
    },
    isMain: function(subscriptionInfo) { return false; },
    titleMenu: 'subscriptionActionShowLog')
});
*/

// Check whether there is any operation (migrating, switch DNS, post-migration checks, etc)
// that is queued or in progress
function _isRunningOrQueued(subscriptionInfo) {
    var operations = getPropertyChain(subscriptionInfo, ['operationStatus'], {});
    for (var operationName in operations) {
        if (operations.hasOwnProperty(operationName)) {
            if (
                operations[operationName] == subscriptionStatus.QUEUED ||
                operations[operationName] == subscriptionStatus.IN_PROGRESS
            ) {
                return true;
            }
        }
    }
    return false;
}

// Find information about operation by its identifier
function findOperation(operationName) {
    for (var i = 0; i < subscriptionOperations.length; i++) {
        var operation = subscriptionOperations[i];
        if (operation.name == operationName) {
            return operation;
        }
    }
}