from parallels.core.connections.database_servers.base import DatabaseServer
from parallels.core.utils.common import is_empty


class ExternalDatabaseServer(DatabaseServer):
    """External database server that could be accessed directly.

    For such database servers customer should specify access settings in configuration file.
    """
    def __init__(self, settings, panel_server, port, user, password, physical_server):
        """
        :type settings: parallels.core.migrator_config.ExternalDBConfigBase
        :type physical_server: parallels.core.connections.physical_server.PhysicalServer
        """
        self._settings = settings
        self._panel_server = panel_server
        self._port = port
        self._password = password
        self._user = user
        self._physical_server = physical_server

    def type(self):
        return self._settings.db_type

    def host(self):
        return self._settings.host

    def port(self):
        return self._port

    def user(self):
        return self._user

    def password(self):
        if not is_empty(self._password):
            return self._password
        else:
            # Try to detect password
            return self.panel_server.get_database_server_password(self)

    @property
    def panel_server(self):
        return self._panel_server

    @property
    def physical_server(self):
        return self._physical_server
