
class Description(object):
    """Description of an object - client, domain"""
    OBJECT_TYPE_DOMAIN = 'domain'
    OBJECT_TYPE_CLIENT = 'client'
    OBJECT_TYPE_RESELLER = 'reseller'

    def __init__(self, node):
        self._node = node

    @property
    def object_type(self):
        """Object type - client or domain

        :rtype: str | unicode
        """
        return self._node.attrib.get('object-type')

    @property
    def object_name(self):
        """Object name - login of a client or domain name

        :rtype: str | unicode
        """
        return self._node.attrib.get('object-name')

    @property
    def value(self):
        """Description text

        :rtype: str | unicode | None
        """
        return self._node.text
