from parallels.core.utils.entity import Entity


class MigrationListData(Entity):
    def __init__(self, subscriptions_mapping, resellers, customers_mapping, plans):
        self._subscriptions_mapping = subscriptions_mapping
        self._resellers = resellers
        self._customers_mapping = customers_mapping
        self._plans = plans

    @property
    def subscriptions_mapping(self):
        """Dictionary with keys - subscription names, values - SubscriptionMappingInfo"""
        return self._subscriptions_mapping

    @property
    def resellers(self):
        """Dictionary with keys - reseller logins that should be migrated, values - reseller plans"""
        return self._resellers

    @property
    def customers_mapping(self):
        """Dictionary with keys - names of customers that should be migrated,
        values - resellers under which to create the customer on target panel"""
        return self._customers_mapping

    @property
    def plans(self):
        """Dictionary with keys - reseller names (None for admin),
        values - sets consisting of names of plans that should be migrated"""
        return self._plans
