
class MigrationListWriterBase(object):
    """Base class for writing migration list to file. Subclasses implement different formats (JSON, plain text)"""

    def __init__(self, source_data):
        """
        :type source_data: parallels.core.migration_list.source_data.MigrationListSourceData
        """
        self._source_data = source_data

    def write_initial(
        self, filename,
        target_subscriptions, target_service_plans, target_addon_service_plans,
        comment_existing_subscriptions=True
    ):
        raise NotImplemented()
