"""Color configuration for reports printed to console

Check documentation of "colorama" library (https://github.com/tartley/colorama)
for more details on available colors.
"""

from parallels.core.thirdparties.colorama import Style, Fore
from parallels.core.utils.common import is_run_on_windows

# Foreground colors
FORE_COLORS = {
    # Parts: 'report-type', 'report-name', 'severity', 'message'
    'report-type': Fore.LIGHTWHITE_EX,
    'report-name': None,
    'severity': {
        # Colors by level: 'default', 'error', 'warning'
        'info': Fore.GREEN,
        'error': Fore.RED,
        'warning': Fore.YELLOW
    },
    'message': {
        'default': None,
    },
}
# Background colors
BACK_COLORS = {
}

# Styles
if is_run_on_windows():
    STYLES = {
        'report-type': Style.BRIGHT,
        'report-name': Style.BRIGHT,
        'severity': {
            # Colors by level: 'default', 'error', 'warning'
            'info': Style.BRIGHT,
            'error': Style.BRIGHT,
            'warning': Style.BRIGHT
        },
        'message': {
            'default': None,
        },
    }
else:
    STYLES = {

    }

