

class IssueIdsSet(object):
    """Class that represents set of unique issues IDS

    That is necessary to use issue ID as an unique key for different types of
    issues.  For example, it makes possible to have solutions for different
    issues in the same dictionary.
    """
    def __init__(self, parent_issue_ids_set=None):
        """
        Arguments:
        - parent_issue_ids_set - take initial set of issues ids from that IssueIdsSet object
        """
        self.ids = set()
        if parent_issue_ids_set is not None:
            self.ids = set(parent_issue_ids_set.ids)

    def unique(self, issue_id):
        """Assert if issue type ID is unique"""
        if issue_id in self.ids:
            raise Exception("Issue ID '%s' is not unique" % issue_id)

        self.ids.add(issue_id)
        return issue_id
