import yaml
from parallels.core.utils.common import read_file_contents
from parallels.plesk.hosting_description.input_formats.base import InputFormat


class InputFormatYAML(InputFormat):
    @property
    def name(self):
        return 'yaml'

    def read(self, filename):
        # Read contents of a file to variable because PyYAML has better error reporting
        # when reading from variable, not from stream (file)
        return yaml.load(read_file_contents(filename))
