class ValidatorBase(object):
    """Base class for validators"""

    def validate(self, document, context=None):
        """Validate specified document (variable) according to current validator's rules

        Return list of found issues.

        :rtype: list[unicode]
        """
        raise NotImplementedError()

    def match_type(self, document):
        """Check whether data type of document matched the validator

        That is necessary condition for "validate" method not to return errors

        :rtype: bool
        """
        return False

    @staticmethod
    def _format_error(error, context):
        if context is None or len(context) == 0:
            return error
        else:
            return '%s: %s' % (", ".join(context), error)
