from parallels.core.hosting_repository.database_user import DatabaseUserModel
from parallels.plesk.hosting_repository.base import PleskBaseModel
from parallels.plesk.hosting_repository.utils.cli.database import DatabaseUserCreateCli, DatabaseUserRegisterCli
from parallels.plesk.hosting_repository.utils.db import db_query


class PleskDatabaseUserModel(DatabaseUserModel, PleskBaseModel):
    def create_from_dump(self, database_user_dump, subscription_name, is_assimilate=False):
        """Create database user in target Plesk

        :type database_user_dump: parallels.core.dump.data_model.DatabaseUser
        :type subscription_name: str
        :type is_assimilate: bool
        """
        if is_assimilate:
            command = DatabaseUserRegisterCli(
                runner=self.plesk_cli_runner,
                database_user_name=database_user_dump.name,
                database_user_password=database_user_dump.password,
                database_user_password_type=database_user_dump.password_type,
                database_name=database_user_dump.database_name,
                database_type=database_user_dump.dbtype,
                database_host=database_user_dump.host,
                database_port=database_user_dump.port,
                subscription_name=subscription_name
            )
        else:
            command = DatabaseUserCreateCli(
                runner=self.plesk_cli_runner,
                database_user_name=database_user_dump.name,
                database_user_password=database_user_dump.password,
                database_user_password_type=database_user_dump.password_type,
                database_name=database_user_dump.database_name,
                database_type=database_user_dump.dbtype,
                database_host=database_user_dump.host,
                database_port=database_user_dump.port,
                subscription_name=subscription_name
            )
        command.run()

    def is_exists(self, database_user_name):
        """Check if database user with given name exists in target Plesk

        :type database_user_name: str
        :rtype: bool
        """
        result = db_query(self.plesk_server, 'SELECT id FROM db_users WHERE login = %(database_user_name)s', dict(
            database_user_name=database_user_name
        ))
        return len(result) > 0
