from parallels.core.hosting_repository.service_plan_addon import ServicePlanAddonModel, ServicePlanAddonEntity
from parallels.core.utils.mysql import escape_args_list
from parallels.plesk.hosting_repository.base import PleskBaseModel
from parallels.plesk.hosting_repository.utils.db import db_query
from parallels.plesk.hosting_repository.utils.service_plan_importer import ServicePlanImporter


class PleskServicePlanAddonModel(ServicePlanAddonModel, PleskBaseModel):
    def get_list(self, filter_id=None, filter_name=None, filter_owner_id=None, filter_owner_username=None):
        """Retrive list of Plesk service plan add-ons by given filter

        :type filter_id: list[int] | None
        :type filter_name: list[str] | None
        :type filter_owner_id: list[int] | None
        :type filter_owner_username: list[str] | None
        :rtype: list[parallels.core.hosting_repository.service_plan_addon.ServicePlanAddonEntity]
        """
        if filter_id is not None and len(filter_id) == 0:
            #  filter by id is empty, so no one service plan add-on could be retrieved
            return []
        if filter_name is not None and len(filter_name) == 0:
            #  filter by name is empty, so no one service plan add-on could be retrieved
            return []
        if filter_owner_id is not None and len(filter_owner_id) == 0:
            #  filter by owner id is empty, so no one service plan add-on could be retrieved
            return []
        if filter_owner_username is not None and len(filter_owner_username) == 0:
            #  filter by owner username is empty, so no one service plan add-on could be retrieved
            return []

        service_plan_addons = []

        query = """
            SELECT
                Templates.id as id,
                Templates.name as name,
                Templates.owner_id as owner_id,
                clients.login as owner_username
            FROM
                Templates left join clients on Templates.owner_id = clients.id
            WHERE
                Templates.type = "domain_addon"
        """
        query_args = {}
        if filter_id is not None:
            filter_id_placeholders, filter_id_values = escape_args_list(filter_id, 'id')
            query += ' AND Templates.id in ({filter_id_placeholders_str})'.format(
                filter_id_placeholders_str=', '.join(filter_id_placeholders)
            )
            query_args.update(filter_id_values)
        if filter_name is not None:
            filter_name_placeholders, filter_name_values = escape_args_list(filter_name, 'name')
            query += ' AND Templates.name in ({filter_name_placeholders_str})'.format(
                filter_name_placeholders_str=', '.join(filter_name_placeholders)
            )
            query_args.update(filter_name_values)
        if filter_owner_id is not None:
            filter_owner_id_placeholders, filter_owner_id_values = escape_args_list(filter_owner_id, 'owner_id')
            query += ' AND Templates.owner_id in ({filter_owner_id_placeholders_str})'.format(
                filter_owner_id_placeholders_str=', '.join(filter_owner_id_placeholders)
            )
            query_args.update(filter_owner_id_values)
        if filter_owner_username is not None:
            filter_owner_username_placeholders, filter_owner_username_values = escape_args_list(
                filter_owner_username, 'owner_username'
            )
            query += ' AND clients.login in ({filter_owner_username_placeholders_str})'.format(
                filter_owner_username_placeholders_str=', '.join(filter_owner_username_placeholders)
            )
            query_args.update(filter_owner_username_values)

        rows = db_query(self.plesk_server, query, query_args)
        for row in rows:
            service_plan_addons.append(ServicePlanAddonEntity(row['id'], row['name'], row['owner_id']))

        return service_plan_addons

    def create(self, name, owner_username, settings):
        """Create service plan add-on with given name, owner and settings in target Plesk

        :type name: str
        :type owner_username: str
        :type settings: parallels.plesk.models.target_data_model.PleskPlanSettings
        """
        ServicePlanImporter().create_service_plan_addon(name, owner_username, settings)
