from parallels.plesk.hosting_repository.utils.cli.base import BaseCli
from parallels.plesk.hosting_repository.utils.cli.utils import add_password_env


class DatabaseAddCli(BaseCli):
    def __init__(self, runner, database_name, database_type, database_host, database_port, subscription_name):
        super(DatabaseAddCli, self).__init__(runner)
        self._database_name = database_name
        self._database_type = database_type
        self._database_host = database_host
        self._database_port = database_port
        self._subscription_name = subscription_name

    @property
    def name(self):
        return 'database'

    def _get_args(self):
        args = [
            self._get_add_arg(), self._database_name,
            '-domain', self._subscription_name,
            '-skip-webspace-checking',
        ]
        if self._database_type is not None:
            args.extend(['-type', self._database_type])
        if self._database_host is not None:
            server_str = self._database_host
            if self._database_port:
                server_str = '%s:%s' % (self._database_host, self._database_port)
            args.extend(['-server', server_str])
        return args

    def _get_add_arg(self):
        raise NotImplementedError()


class DatabaseCreateCli(DatabaseAddCli):
    def _get_add_arg(self):
        return '--create'


class DatabaseRegisterCli(DatabaseAddCli):
    def _get_add_arg(self):
        return '--register'


class DatabaseUserAddCli(BaseCli):
    def __init__(
        self, runner, database_user_name, database_user_password, database_user_password_type,
        database_name, database_type, database_host, database_port,
        subscription_name
    ):
        super(DatabaseUserAddCli, self).__init__(runner)
        self._database_user_name = database_user_name
        self._database_user_password = database_user_password
        self._database_user_password_type = database_user_password_type
        self._database_name = database_name
        self._database_type = database_type
        self._database_host = database_host
        self._database_port = database_port
        self._subscription_name = subscription_name

    @property
    def name(self):
        return 'database'

    def _get_args(self):
        args = [
            self._get_add_arg(), self._database_user_name,
            '-passwd', '',
            '-domain', self._subscription_name
        ]
        if self._database_name is not None:
            args.extend(['-database', self._database_name])
        else:
            args.extend(['-any-database'])
        if self._database_type is not None:
            args.extend(['-type', self._database_type])
        if self._database_host is not None:
            server_str = self._database_host
            if self._database_port:
                server_str = '%s:%s' % (self._database_host, self._database_port)
            args.extend(['-server', server_str])
        return args

    def _get_env(self):
        return add_password_env({}, self._database_user_password, self._database_user_password_type)

    def _get_add_arg(self):
        raise NotImplementedError()


class DatabaseUserCreateCli(DatabaseUserAddCli):
    def _get_add_arg(self):
        return '--create-dbuser'


class DatabaseUserRegisterCli(DatabaseUserAddCli):
    def _get_add_arg(self):
        return '--register-dbuser'
