# Copyright 1999-2012. Parallels IP Holdings GmbH. All Rights Reserved.
package PreMigrationMessages;

use strict;
use warnings;

use PreMigration;

# Context variables common to all messages
our %COMMON_CONTEXT = (
    'panel_name' => 'Parallels Confixx',
  );

our $pleskDoesNotSupport = 'They will not be migrated because there is no such a feature in Parallels Plesk Panel.';

our %MESSAGES = (
  'AUTORESPONDER_FOR_CATCH_ALL_EMAIL' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => 'Autoresponder for *@{domain} catch-all e-mail will not be migrated because it is not supported by Parallels Plesk Panel.',
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support autoresponders on catch-all e-mails.'
  },
  'PHONE_CONTAINS_SLASHES' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The phone number '{phone}' of the user '{user}' contains slashes which are not allowed in Parallels Plesk Panel. All slashes will be removed.",
    'detailedMessage' => 'After migration, check the phone number and correct it, if necessary.'
  },
  'FAX_CONTAINS_SLASHES' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The fax number '{fax}' of the user '{user}' contains slashes which are not allowed in Parallels Plesk Panel. All slashes will be removed.",
    'detailedMessage' => 'After migration, check the fax number and correct it, if necessary.'
  },
  'CAN_NOT_CONVERT_COUNTRY_CODE' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The record about the user '{user}' country '{country}' will not be migrated because the migration agent is unable to map it to a country supported by Parallels Plesk Panel.",
    'detailedMessage' => 'After migration, check the country name and select the proper value, if necessary.'
  },
  'CAN_NOT_CONVERT_LOCALE' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The record about the language '{language}' for the user '{user}' will not be migrated because migration agent is unable to map it to a language supported by Parallels Plesk Panel.",
    'detailedMessage' => 'After migration, set the correct language for the user, if necessary.'
  },
  'CAN_NOT_CONVERT_IDN_DOMAIN' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "Unable to convert the IDN domain {domain} to UTF-8: {reason}. After migration, this domain name will be represented by a string in Punycode.",
    'detailedMessage' => 'Check that idnconv utility is installed on the server and works correctly. For detailed information on how to install idnconv, refer to Parallels Confixx Installation and Upgrade Guide, section "Install IDNKit": http://download1.parallels.com/Confixx/ConfixxPro3.3/3.3.8/docs/manuals/en/Installation/confixx-3.3.8-installation-upgrade-guide.pdf.'
  },
  'SPAMASSASSIN_DUPLICATE_SETTING' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "SpamAssassin configuration for the mailbox '{mboxName}' on the domain '{domain}' contains duplicate '{param_name}' values. The last of these values will be used during migration.",
    'detailedMessage' => 'Most probably, it is a misconfiguration of SpamAssassin. After migration, check that SpamAssassin settings are properly set for that mailbox.'
  },
  'SPAMASSASSIN_NO_SUCH_OPTION_IN_PLESK' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "SpamAssassin configuration for the mailbox '{mboxName}' on the domain '{domain}' contains the parameter '{param_name}' with the value '{param_value}' which cannot be migrated to Parallels Plesk Panel.",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support advanced configuration of SpamAssassin.'
  },
  'MAIL_MAPPING_MBOX_TARGET' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The mailbox '{mboxName}' on the domain '{domain}' will be migrated to Parallels Plesk Panel's e-mail address '{destinationEmail}'.",
    'detailedMessage' => ''
  },
  'MAIL_MAPPING_CATCH_ALL_EMAIL_TARGET' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "All catch-all e-mail addresses on the domain '{domain}' will be migrated to Parallels Plesk Panel's e-mail address '{destinationEmail}'.",
    'detailedMessage' => ''
  },
  'MAIL_MAPPING_EMAIL_MIGRATED_AS_IS' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The e-mail address '{email}' will be migrated as is.",
    'detailedMessage' => ''
  },
  'MAIL_MAPPING_EMAIL_MIGRATED_WITH_MAILBOX' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The e-mail address '{email}' will be migrated as is, along with its mailbox '{mboxName}'.",
    'detailedMessage' => ''
  },
  'MAIL_MAPPING_FORWARDING' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The e-mail address '{email}' will be added to forwarders of Parallels Plesk Panel's e-mail address '{destinationEmail}'.",
    'detailedMessage' => ''
  },
  'MAIL_MAPPING_ALIAS' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The e-mail address '{email}' will be migrated as an alias of Parallels Plesk Panel's e-mail address '{destinationEmail}'.",
    'detailedMessage' => ''
  },
  'MAIL_MAPPING_PLESK_CATCH_ALL_FORWARDED_TO' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "All mail sent to nonexistent users on the domain '{domain}' in Parallels Plesk Panel will be forwarded to '{email}'.",
    'detailedMessage' => ''
  },
  'CUSTOMER_WITH_NO_DOMAINS' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The user '{user}' does not have any domains, therefore, a system domain '{systemDomain}' will be created.",
    'detailedMessage' => 'In Parallels Plesk Panel, most of the features, like databases and file storage, are available only if a customer has at least one domain name. In Parallels Confixx, a customer is not obliged to have domains to use these features.'
  },
  'CUSTOMER_HAS_NO_SYSTEM_DOMAIN' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The user '{user}' does not have a system domain. Migration agent will generate a new system domain: '{systemDomain}'.",
    'detailedMessage' => ""
  },
  'DOMAIN_HTTPD_SPECIALS' => {
    'severity' => PreMigration::WARNING,
    'briefMessage' => "The Apache configuration for the domain '{domain}' is customized with HTTPD specials. Migration of HTTPD specials is not supported.",
    'detailedMessage' => "Customize domains's configuration manually after migration"
  },
  'SHARED_DOMAINS' => {
    'severity' => PreMigration::WARNING,
    'briefMessage' => "The user '{user}' has one or more shared domains ({domains}). $pleskDoesNotSupport",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support shared domains.'
  },
  'PERSONAL_INFO_CUSTOM_FIELDS' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "There are custom fields defined in customer profile of '{user}'. $pleskDoesNotSupport",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support custom fields.'
  },
  'SCPONLY_NOT_SUPPORTED' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "Scp/SFTP shell type is not supported by Parallels Plesk Panel; therefore, after migration, no shell access will be granted to the user '{user}'.",
    'detailedMessage' => 'Consider using FTP or enabling shell access for that user.'
  },
  'BOTH_AWSTATS_AND_WEBALIZER_ENABLED' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "Both AWStats and Webalizer are enabled for the user '{user}'. Parallels Plesk Panel can have only one of them enabled per domain, therefore, only the default one will be enabled.",
    'detailedMessage' => "The user can later select another statistics tool in subscription settings."
  },
  'RESELLER_DNS_SPECIALS' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "Reseller's DNS template is found for '{user}'. It will not be migrated because Parallels Plesk Panel does not support that feature.",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support reseller DNS templates.'
  },
  'CLIENT_CUSTOM_ERROR_DOCS' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The user '{user}' has custom error documents. Their migration is not supported, and in general, Parallels Confixx supports per-directory error documents, while Parallels Plesk Panel supports only per-site error documents.",
    'detailedMessage' => 'Migrate all the necessary error documents manually.'
  },
  'AT_DOMAINS' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The user '{user}' has one or more at-domains ({atdomains}). $pleskDoesNotSupport",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support at-domains.'
  },
  'EMAILS_WITH_PERCENT_SIGN' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The user '{user}' has one or more e-mail addresses with percentage sign ('%') in their names ({emails}). Such e-mail addresses will not be migrated because they are not supported by Parallels Plesk Panel.",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support percentage signs in e-mail addresses.'
  },
  'RESELLER_HELP_MESSAGE' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "A custom help message was found for the reseller '{user}'. It will not be migrated because Parallels Plesk Panel does not support such a feature.",
    'detailedMessage' => 'There is no solution: Parallels Plesk Panel does not support showing custom messages from Resellers in Panel.'
  },
  'ADDRESSBOOK' => {
    'severity' => PreMigration::INFO,
    'briefMessage' => "The user '{user}' has entries in the address book. Not everything from the address book can be migrated.",
    'detailedMessage' => "For example, first and last names are not migrated, only the formatted name is migrated to an alias. After migration, check that nothing important was lost during migration."
  },
  'UNKNOWN_MAILDROP' => {
    'severity' => PreMigration::ERROR,
    'briefMessage' => "Maildrop '{maildrop}' is not supported by migration agent. Mail content will not be migrated.",
    'detailedMessage' => 'Check that confixx_main.conf is correct. Only migrations from "HOMEDIR/Maildir/", "HOMEDIR/Mailbox", and "/var/spool/mail/USER" are supported. Switch to one of these values before migration.'
  },
  'SINGLE_WORD_DOMAIN' => {
    'severity' => PreMigration::WARNING,
    'briefMessage' => "User '{user}' has a single-word domain '{domain}' which is not supported by Parallels Plesk Panel. Domain will be renamed to '{newDomain}'.",
    'detailedMessage' => ''
  },
  'CRON_JOBS' => {
    'severity' => PreMigration::WARNING,
    'briefMessage' => "User '{user}' has crontab entries. Cron jobs are migrated as-is, without verification of filesystem paths or commands.",
    'detailedMessage' => 'After migration is completed, check that the commands and filesystem paths specified in cron jobs exist on the Plesk server.'
  },
);
