# coding=utf-8
from parallels.core.utils.message_utils import single_line_message, load_overrides

LOG_MIGRATE_MAIL_CONTENT_OF_SUBSCRIPTION = single_line_message("""
    Migrating mail content for subscription '%s'.
""")
REPORT_TITLE_INFRASTRUCTURE_CHECKS_CONNECTIONS = single_line_message("""
    Connections required for source and the destination %s server
""")
FAILED_TO_CHECK_CONNECTIONS = single_line_message("""
    Failed to check connections between for source and the destination %s server
""")
CANNOT_GET_PASSWORD_FOR_UNSUPPORTED_DB_TYPE = single_line_message("""
    Cannot retrieve password for an unsupported database type "%s"
""")
LOG_CHECK_CONNECTION_REQUIREMENTS = single_line_message("""
    Check connection requirements
""")
LOG_CHECK_DISK_SPACE_REQUIREMENTS = single_line_message("""
    Check disk space requirements
""")
REPORT_TARGET_DISK_SPACE_REQUIREMENTS = single_line_message("""
    Disk space requirements
""")
ACTION_FETCH_SOURCE = single_line_message("""
    Fetch data from source cPanel
""")
UNABLE_COPY_DATABASE_CONTENT = single_line_message("""
    Unable to copy content of database '%s' on subscription '%s'. Trying to copy content again.
""")
FAILED_COPY_DATABASE_CONTENT = single_line_message("""
    Failed to copy content of the database '%s'
""")
UNABLE_COPY_CONTENT_DATABASE_S_SUBSCRIPTION_1 = single_line_message("""
    Unable to copy content of database '%s' on subscription '%s'. Trying to copy content again.
""")
FAILED_COPY_CONTENT_DATABASE_S_1 = single_line_message("""
    Failed to copy content of database '%s'
""")
ACTION_TITLE_FIX_SPAMASSASSIN_PATTERNS = single_line_message("""
    Fix SpamAssassin whitelist and blacklist patterns
""")
ACTION_FAILURE_FIX_SPAMASSASSIN_PATTERNS = single_line_message("""
    Failed to fix SpamAssassin whitelist and blacklist patterns
""")
LOG_CHANGED_SPAMASSASSIN_PATTERN = single_line_message("""
    Changed SpamAssassin pattern '{old_pattern}' to '{new_pattern}' for mailbox '{mailbox_name}'
""")

# Load language and UI type overrides. That must be the last line of root messages file.
load_overrides(__name__, locals())
