from parallels.core.actions.hosting_settings.convert.change_hosting_subscription_web_ips import \
    ChangeHostingSubscriptionWebIPs
from parallels.core.actions.hosting_settings.convert.change_subscription_mail_ips import ChangeSubscriptionMailIPs
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.actions.hosting_settings.convert.change_no_hosting_subscription_web_ips import \
    ChangeNoHostingSubscriptionWebIPsPlesk
from parallels.plesk.source.plesk.workflow import WorkflowExtension as SourcePleskWorkflowExtension
from parallels.plesk.source.expand.actions.fetch.fetch_expand_data import FetchExpandData
from parallels.plesk.source.expand.actions.hosting_settings.restore_centralized_mail_hosting_settings import \
    RestoreCentralizedMailHostingSettings

from parallels.plesk.source.expand.actions.fetch.fetch_backup_cmail import \
    FetchCentralizedMailBackupAction
from parallels.core.actions.backup.create_converted \
    import CreateConverted
from parallels.core.actions.backup.save_converted \
    import SaveConverted
from parallels.core.actions.backup.remove_content \
    import RemoveContent
from parallels.core.actions.hosting_settings.convert.remap_databases \
    import RemapDatabases
from parallels.core.actions.hosting_settings.convert.remove_subscription_to_plan_relation \
    import RemoveSubscriptionToPlanRelation
from parallels.core.actions.hosting_settings.convert.remove_subscription_default_db_server \
    import RemoveSubscriptionDefaultDBServer
from parallels.core.actions.hosting_settings.convert.remove_subscription_limits_and_permissions \
    import RemoveSubscriptionLimitsAndPermissions
from parallels.core.actions.hosting_settings.convert.change_webmail_to_horde \
    import ChangeWebmailToHorde
from parallels.core.actions.hosting_settings.convert.remove_subscription_external_id \
    import RemoveSubscriptionExternalId
from parallels.core.actions.hosting_settings.convert.change_sysuser_password \
    import ChangeSysuserPassword
from parallels.core.actions.hosting_settings.convert.change_smartermail_password \
    import ChangeSmartermailPassword
from parallels.core.actions.hosting_settings.convert.change_sysuser_login import ChangeSysuserLogin
from parallels.core.actions.hosting_settings.check.email_empty_password \
    import EmailEmptyPassword

from parallels.plesk.source.expand.utils.backup_adapter \
    import CentralizedMailBackup
from parallels.plesk.source.expand.utils.backup_adapter \
    import CentralizedMailBackupRaw

from parallels.plesk.source.plesk.actions.dns.forwarding.add_source_dns_acl import AddSourceToTargetDNSACL
from parallels.plesk.source.plesk.actions.dns.forwarding.add_source_dns_axfr import AddSourceToTargetDNSAXFR


class WorkflowExtension(WorkflowExtensionBase):
    def extend_workflow(self, workflow):
        """Extend shared hosting workflow with source-panel specific actions

        :type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
        """
        SourcePleskWorkflowExtension().extend_workflow(workflow)

        workflow.get_shared_action('fetch-source').insert_action(
            'fetch-expand', FetchExpandData()
        )
        workflow.get_shared_action('fetch-source').insert_action(
            'fetch-centralized-mail', FetchCentralizedMailBackupAction()
        )
        workflow.get_shared_action('fetch-source-shallow').insert_action(
            'fetch-expand', FetchExpandData()
        )

        convert_hosting = workflow.get_shared_action('convert-hosting')
        cmail_backup = CentralizedMailBackup()
        convert_hosting.insert_actions([
            ('cmail-create-converted-backup', CreateConverted(cmail_backup)),
            ('cmail-remap-databases', RemapDatabases(cmail_backup)),
            ('cmail-remove-subscription-to-plan-relation', RemoveSubscriptionToPlanRelation(cmail_backup)),
            ('cmail-remove-subscription-default-db-server', RemoveSubscriptionDefaultDBServer(cmail_backup)),
            ('cmail-remove-subscription-limits-and-permissions', RemoveSubscriptionLimitsAndPermissions(cmail_backup)),
            ('cmail-change-webmail-to-horde', ChangeWebmailToHorde(cmail_backup)),
            ('change-hosting-subscription-web-ips', ChangeHostingSubscriptionWebIPs(cmail_backup)),
            ('change-no-hosting-subscription-web-ips', ChangeNoHostingSubscriptionWebIPsPlesk(cmail_backup)),
            ('change-subscription-mail-ips', ChangeSubscriptionMailIPs(cmail_backup)),
            ('cmail-remove-subscription-external-id', RemoveSubscriptionExternalId(cmail_backup)),
            ('cmail-change-sysuser-password', ChangeSysuserPassword(cmail_backup)),
            ('cmail-change-smartermail-password', ChangeSmartermailPassword(cmail_backup)),
            ('cmail-backup-remove-content', RemoveContent(cmail_backup)),
            ('cmail-check-email-empty-password', EmailEmptyPassword(cmail_backup)),
        ], before='save-backup')
        convert_hosting.insert_action(
            'cmail-save-backup', SaveConverted(cmail_backup),
            after='save-backup'
        )

        workflow.get_path('transfer-accounts/deploy/restore-sysuser-logins').insert_action(
            'cmail-change-sysuser-logins', ChangeSysuserLogin(cmail_backup), after='change-sysuser-logins'
        )
        workflow.get_path('transfer-accounts/deploy/restore-sysuser-logins').insert_action(
            'cmail-save-backup', SaveConverted(cmail_backup), after='save-backup'
        )

        workflow.get_path('check/check-data').insert_action(
            'check-mail-email-empty-password',
            EmailEmptyPassword(CentralizedMailBackupRaw())
        )

        workflow.get_path('transfer-accounts/restore-hosting').insert_action(
            'restore-centralized-mail-hosting-settings',
            RestoreCentralizedMailHostingSettings(),
            before='restore-hosting-settings'
        )

        # DNS forwarding
        workflow.get_path('set-dns-forwarding').insert_action(
            'add-source-to-target-dns-acl', AddSourceToTargetDNSACL(), before='forward-dns'
        )
        workflow.get_path('set-dns-forwarding').insert_action(
            'add-source-to-target-dns-axfr', AddSourceToTargetDNSAXFR(), before='forward-dns'
        )
