from parallels.core.utils.common import cached
from parallels.core.connections.source_server import SourceServer
from parallels.core.utils.windows_mysql_client_deploy import deploy_mysql_client
from parallels.core.utils.windows_mysql_client_deploy import deploy_mysqldump


class Helm3SourceServer(SourceServer):
    """Source server for migration from Helm 3"""

    @cached
    def get_path_to_mysqldump(self):
        """Deploy mysqldump.exe and return path to it on that source server

        :rtype: str
        """
        return deploy_mysqldump(self)

    @cached
    def get_path_to_mysql(self):
        """Deploy mysql.exe and return path to it on that source server

        :rtype: str
        """
        return deploy_mysql_client(self)

    def mysql_use_skip_secure_auth(self):
        """Whether to pass --skip-secure-auth flag to MySQL client

        This flag is necessary when client version is greater than server version.
        We deploy own MySQL client, it could be of greater version than server,
        so we should pass the flag.
        """
        return True

    def __repr__(self):
        """Object Python representation"""
        return 'Helm3SourceServer(%r)' % (self.node_id,)